/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLibraryAction
extends DumbAwareAction {
    @Nullable
    private final LibraryType myType;
    private final BaseLibrariesConfigurable myLibrariesConfigurable;
    private final Project myProject;

    private CreateNewLibraryAction(@NotNull String text, @Nullable Icon icon, @Nullable LibraryType type, @NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull Project project) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "<init>"));
        }
        if (librariesConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "<init>"));
        }
        super(text, null, icon);
        this.myType = type;
        this.myLibrariesConfigurable = librariesConfigurable;
        this.myProject = project;
    }

    public void actionPerformed(AnActionEvent e) {
        Library library = CreateNewLibraryAction.createLibrary(this.myType, (JComponent)this.myLibrariesConfigurable.getTree(), this.myProject, this.myLibrariesConfigurable.getModelProvider().getModifiableModel());
        if (library == null) {
            return;
        }
        BaseLibrariesConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        MasterDetailsComponent.MyNode libraryNode = MasterDetailsComponent.findNodeByObject((TreeNode)((TreeNode)rootConfigurable.getTree().getModel().getRoot()), (Object)library);
        rootConfigurable.selectNodeInTree((DefaultMutableTreeNode)libraryNode);
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.myProject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Library createLibrary(@Nullable LibraryType type, @NotNull JComponent parentComponent, @NotNull Project project, @NotNull LibrariesModifiableModel modifiableModel) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createLibrary"));
        }
        if (modifiableModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createLibrary"));
        }
        NewLibraryConfiguration configuration = CreateNewLibraryAction.createNewLibraryConfiguration(type, parentComponent, project);
        if (configuration == null) {
            return null;
        }
        LibraryType<?> libraryType = configuration.getLibraryType();
        Library library = modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName(modifiableModel, configuration.getDefaultLibraryName()), (PersistentLibraryKind)(libraryType != null ? libraryType.getKind() : null));
        NewLibraryEditor editor = new NewLibraryEditor(libraryType, configuration.getProperties());
        configuration.addRoots(editor);
        Library.ModifiableModel model = library.getModifiableModel();
        editor.applyTo((LibraryEx.ModifiableModelEx)model);
        AccessToken token = WriteAction.start();
        try {
            model.commit();
        }
        finally {
            token.finish();
        }
        return library;
    }

    @Nullable
    public static NewLibraryConfiguration createNewLibraryConfiguration(@Nullable LibraryType type, @NotNull JComponent parentComponent, @NotNull Project project) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createNewLibraryConfiguration"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createNewLibraryConfiguration"));
        }
        VirtualFile baseDir = project.getBaseDir();
        NewLibraryConfiguration configuration = type != null ? type.createNewLibrary(parentComponent, baseDir, project) : LibraryTypeService.getInstance().createLibraryFromFiles(new DefaultLibraryRootsComponentDescriptor(), parentComponent, baseDir, null, project);
        if (configuration == null) {
            return null;
        }
        return configuration;
    }

    public static AnAction[] createActionOrGroup(@NotNull String text, @NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull Project project) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createActionOrGroup"));
        }
        if (librariesConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createActionOrGroup"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction", "createActionOrGroup"));
        }
        LibraryType[] extensions = (LibraryType[])LibraryType.EP_NAME.getExtensions();
        ArrayList<LibraryType> suitableTypes = new ArrayList<LibraryType>();
        if (librariesConfigurable instanceof ProjectLibrariesConfigurable || !project.isDefault()) {
            ModuleStructureConfigurable configurable = ModuleStructureConfigurable.getInstance(project);
            for (LibraryType extension : extensions) {
                if (LibraryEditingUtil.getSuitableModules(configurable, extension.getKind(), null).isEmpty()) continue;
                suitableTypes.add(extension);
            }
        } else {
            Collections.addAll(suitableTypes, extensions);
        }
        if (suitableTypes.isEmpty()) {
            return new AnAction[]{new CreateNewLibraryAction(text, PlatformIcons.LIBRARY_ICON, null, librariesConfigurable, project)};
        }
        ArrayList<CreateNewLibraryAction> actions = new ArrayList<CreateNewLibraryAction>();
        actions.add(new CreateNewLibraryAction(IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]), PlatformIcons.LIBRARY_ICON, null, librariesConfigurable, project));
        for (LibraryType type : suitableTypes) {
            String actionName = type.getCreateActionName();
            if (actionName == null) continue;
            actions.add(new CreateNewLibraryAction(actionName, type.getIcon(), type, librariesConfigurable, project));
        }
        return actions.toArray(new AnAction[actions.size()]);
    }
}

