/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleOutputSourceItem
extends PackagingSourceItem {
    private final Module myModule;

    public ModuleOutputSourceItem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem", "<init>"));
        }
        this.myModule = module;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleOutputSourceItem && this.myModule.equals(((ModuleOutputSourceItem)((Object)obj)).myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem", "createPresentation"));
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)context.getProject()).create(this.myModule);
        return new DelegatedSourceItemPresentation(new ModuleElementPresentation(modulePointer, context, false)){

            @Override
            public int getWeight() {
                return 30;
            }
        };
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem", "createElements"));
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)context.getProject()).create(this.myModule);
        List<ProductionModuleOutputPackagingElement> list = Collections.singletonList(new ProductionModuleOutputPackagingElement(context.getProject(), modulePointer));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem", "createElements"));
        }
        return list;
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem", "getKindOfProducedElements"));
        }
        return packagingElementOutputKind;
    }
}

