/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.nodes;

import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingNodeSource {
    private final ComplexPackagingElement<?> mySourceElement;
    private final PackagingElementNode<?> mySourceParentNode;
    private final CompositePackagingElement<?> mySourceParentElement;
    private final Collection<PackagingNodeSource> myParentSources;

    public PackagingNodeSource(@NotNull ComplexPackagingElement<?> sourceElement, @NotNull PackagingElementNode<?> sourceParentNode, @NotNull CompositePackagingElement<?> sourceParentElement, @Nullable Collection<PackagingNodeSource> parentSources) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource", "<init>"));
        }
        if (sourceParentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource", "<init>"));
        }
        if (sourceParentElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource", "<init>"));
        }
        this.mySourceElement = sourceElement;
        this.mySourceParentNode = sourceParentNode;
        this.mySourceParentElement = sourceParentElement;
        this.myParentSources = parentSources;
    }

    @NotNull
    public ComplexPackagingElement<?> getSourceElement() {
        ComplexPackagingElement<?> complexPackagingElement = this.mySourceElement;
        if (complexPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource", "getSourceElement"));
        }
        return complexPackagingElement;
    }

    @NotNull
    public PackagingElementNode<?> getSourceParentNode() {
        PackagingElementNode<?> packagingElementNode = this.mySourceParentNode;
        if (packagingElementNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource", "getSourceParentNode"));
        }
        return packagingElementNode;
    }

    @NotNull
    public CompositePackagingElement<?> getSourceParentElement() {
        CompositePackagingElement<?> compositePackagingElement = this.mySourceParentElement;
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource", "getSourceParentElement"));
        }
        return compositePackagingElement;
    }

    public Collection<PackagingNodeSource> getParentSources() {
        return this.myParentSources;
    }

    public String getPresentableName() {
        return this.mySourceElement.createPresentation(this.mySourceParentNode.getContext()).getPresentableName();
    }
}

