/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeleteProvider
implements DeleteProvider,
TitledHandler {
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider", "canDeleteElement"));
        }
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        return modules != null && !ModuleDeleteProvider.isPrimaryModule(modules);
    }

    private static boolean isPrimaryModule(Module[] modules) {
        if (!ProjectAttachProcessor.canAttachToProject()) {
            return !PlatformUtils.isIdeaUltimate();
        }
        for (Module module : modules) {
            File moduleFile = new File(module.getModuleFilePath());
            File projectFile = new File(module.getProject().getProjectFilePath());
            if (!moduleFile.getParent().equals(projectFile.getParent()) || !moduleFile.getParentFile().getName().equals(".idea")) continue;
            return true;
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider", "deleteElement"));
        }
        final Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        assert (modules != null);
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        String names = StringUtil.join(Arrays.asList(modules), (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return "'" + module.getName() + "'";
            }
        }, (String)", ");
        int ret = Messages.showOkCancelDialog((String)ModuleDeleteProvider.getConfirmationText(modules, names), (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                        Module[] currentModules = moduleManager.getModules();
                        ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
                        HashMap<Module, ModifiableRootModel> otherModuleRootModels = new HashMap<Module, ModifiableRootModel>();
                        for (Module module : modules) {
                            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                            for (Module otherModule : currentModules) {
                                if (otherModule == module || ArrayUtilRt.find((Object[])modules, (Object)otherModule) != -1 || otherModuleRootModels.containsKey(otherModule)) continue;
                                otherModuleRootModels.put(otherModule, ModuleRootManager.getInstance((Module)otherModule).getModifiableModel());
                            }
                            ModuleDeleteProvider.removeModule(module, modifiableModel, otherModuleRootModels.values(), modifiableModuleModel);
                        }
                        ModifiableRootModel[] modifiableRootModels = otherModuleRootModels.values().toArray(new ModifiableRootModel[otherModuleRootModels.size()]);
                        ModifiableModelCommitter.multiCommit(modifiableRootModels, modifiableModuleModel);
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, ProjectBundle.message((String)"module.remove.command", (Object[])new Object[0]), null);
    }

    private static String getConfirmationText(Module[] modules, String names) {
        if (ProjectAttachProcessor.canAttachToProject()) {
            return ProjectBundle.message((String)"project.remove.confirmation.prompt", (Object[])new Object[]{names, modules.length});
        }
        return ProjectBundle.message((String)"module.remove.confirmation.prompt", (Object[])new Object[]{names, modules.length});
    }

    public String getActionTitle() {
        return ProjectAttachProcessor.canAttachToProject() ? "Remove from Project View" : "Remove Module";
    }

    public static void removeModule(@NotNull Module moduleToRemove, @Nullable ModifiableRootModel modifiableRootModelToRemove, @NotNull Collection<ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (moduleToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider", "removeModule"));
        }
        if (otherModuleRootModels == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider", "removeModule"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider", "removeModule"));
        }
        for (ModifiableRootModel modifiableRootModel : otherModuleRootModels) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = modifiableRootModel.getOrderEntries()) {
                Module orderEntryModule;
                if (!(orderEntry instanceof ModuleOrderEntry) || !orderEntry.isValid() || (orderEntryModule = ((ModuleOrderEntry)orderEntry).getModule()) == null || !orderEntryModule.equals(moduleToRemove)) continue;
                modifiableRootModel.removeOrderEntry(orderEntry);
            }
        }
        if (modifiableRootModelToRemove != null) {
            modifiableRootModelToRemove.dispose();
        }
        moduleModel.disposeModule(moduleToRemove);
    }
}

