/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class SidePanel
extends JPanel {
    private final JList myList;
    private final DefaultListModel myModel;
    private final Place.Navigator myNavigator;
    private final ArrayList<Place> myPlaces = new ArrayList();
    private final Map<Integer, String> myIndex2Separator = new HashMap<Integer, String>();
    private final Map<Place, Presentation> myPlace2Presentation = new HashMap<Place, Presentation>();
    private final History myHistory;

    public SidePanel(Place.Navigator navigator, History history) {
        this.myHistory = history;
        this.myNavigator = navigator;
        this.setLayout(new BorderLayout());
        this.myModel = new DefaultListModel();
        this.myList = new JBList((ListModel)this.myModel);
        ListItemDescriptor descriptor = new ListItemDescriptor(){

            public String getTextFor(Object value) {
                return ((Presentation)SidePanel.this.myPlace2Presentation.get(value)).getText();
            }

            public String getTooltipFor(Object value) {
                return this.getTextFor(value);
            }

            public Icon getIconFor(Object value) {
                return null;
            }

            public boolean hasSeparatorAboveOf(Object value) {
                int index = SidePanel.this.myPlaces.indexOf(value);
                return SidePanel.this.myIndex2Separator.get(index) != null;
            }

            public String getCaptionAboveOf(Object value) {
                return (String)SidePanel.this.myIndex2Separator.get(SidePanel.this.myPlaces.indexOf(value));
            }
        };
        this.myList.setCellRenderer(new GroupedItemsListRenderer(descriptor));
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object value = SidePanel.this.myList.getSelectedValue();
                if (value != null) {
                    SidePanel.this.myNavigator.navigateTo((Place)value, false);
                }
            }
        });
    }

    public void addPlace(Place place, @NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/SidePanel", "addPlace"));
        }
        this.myModel.addElement(place);
        this.myPlaces.add(place);
        this.myPlace2Presentation.put(place, presentation);
        this.revalidate();
        this.repaint();
    }

    public void addSeparator(String text) {
        this.myIndex2Separator.put(this.myPlaces.size(), text);
    }

    public Collection<Place> getPlaces() {
        return this.myPlaces;
    }

    public void select(Place place) {
        this.myList.setSelectedValue(place, true);
    }
}

