/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.JavaVfsSourceRootDetectionUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PathUIUtils {
    public static final RootDetector JAVA_SOURCE_ROOT_DETECTOR = new RootDetector(OrderRootType.SOURCES, false, "sources"){

        @Override
        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/PathUIUtils$1", "detectRoots"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/PathUIUtils$1", "detectRoots"));
            }
            List<VirtualFile> list = JavaVfsSourceRootDetectionUtil.suggestRoots(rootCandidate, progressIndicator);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/PathUIUtils$1", "detectRoots"));
            }
            return list;
        }
    };

    private PathUIUtils() {
    }

    public static VirtualFile[] scanAndSelectDetectedJavaSourceRoots(Component parentComponent, VirtualFile[] rootCandidates) {
        List<OrderRoot> orderRoots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), parentComponent, null, new LibraryRootsDetectorImpl(Collections.singletonList(JAVA_SOURCE_ROOT_DETECTOR)), new OrderRootType[0]);
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (OrderRoot root : orderRoots) {
            result.add(root.getFile());
        }
        return VfsUtil.toVirtualFileArray(result);
    }
}

