/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesCombobox
extends ComboBox {
    private final SortedComboBoxModel<Module> myModel;

    public ModulesCombobox() {
        this((SortedComboBoxModel<Module>)new SortedComboBoxModel((Comparator)ModulesAlphaComparator.INSTANCE));
    }

    private ModulesCombobox(SortedComboBoxModel<Module> model) {
        super(model);
        this.myModel = model;
        new ComboboxSpeedSearch((JComboBox)((Object)this)){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return "";
                }
                return super.getElementText(element);
            }
        };
        this.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getName());
                    this.setIcon(ModuleType.get((Module)value).getIcon());
                } else {
                    this.setText("[none]");
                }
            }
        });
    }

    public void fillModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/ModulesCombobox", "fillModules"));
        }
        this.fillModules(project, null);
    }

    public void fillModules(@NotNull Project project, @Nullable ModuleType moduleType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/ModulesCombobox", "fillModules"));
        }
        this.myModel.clear();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (moduleType != null && !moduleType.equals((Object)ModuleType.get((Module)module))) continue;
            this.myModel.add((Object)module);
        }
    }

    public void setSelectedModule(@Nullable Module module) {
        this.myModel.setSelectedItem((Object)module);
    }

    @Nullable
    public Module getSelectedModule() {
        return (Module)this.myModel.getSelectedItem();
    }
}

