/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Chunk;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GeneralProjectSettingsElement
extends ProjectStructureElement {
    public GeneralProjectSettingsElement(@NotNull StructureConfigurableContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "<init>"));
        }
        super(context);
    }

    @Override
    public String getPresentableName() {
        return "Project";
    }

    @Override
    public String getTypeName() {
        return "Project";
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        Graph graph = ModuleCompilerUtil.toChunkGraph(this.myContext.getModulesConfigurator().createGraphGenerator());
        Collection chunks = graph.getNodes();
        ArrayList<String> cycles = new ArrayList<String>();
        for (Chunk chunk : chunks) {
            Set modules = chunk.getNodes();
            ArrayList<String> names = new ArrayList<String>();
            for (ModuleRootModel model : modules) {
                names.add(model.getModule().getName());
            }
            if (modules.size() <= 1) continue;
            cycles.add(StringUtil.join(names, (String)", "));
        }
        if (!cycles.isEmpty()) {
            String description;
            String message;
            Project project = this.myContext.getProject();
            PlaceInProjectStructureBase place = new PlaceInProjectStructureBase(project, ProjectStructureConfigurable.getInstance(project).createModulesPlace(), this);
            if (cycles.size() > 1) {
                message = "Circular dependencies";
                String br = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
                StringBuilder cyclesString = new StringBuilder();
                for (int i = 0; i < cycles.size(); ++i) {
                    cyclesString.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;").append(i + 1).append(". ").append((String)cycles.get(i));
                }
                description = ProjectBundle.message((String)"module.circular.dependency.warning.description", (Object[])new Object[]{cyclesString});
            } else {
                message = ProjectBundle.message((String)"module.circular.dependency.warning.short", (Object[])new Object[]{cycles.get(0)});
                description = null;
            }
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, place, ProjectStructureProblemType.warning("module-circular-dependency"), Collections.emptyList()));
        }
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return "project:general";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GeneralProjectSettingsElement;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

