/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Map;

class SuggestedChildRootInfo {
    private final VirtualFile myRootCandidate;
    private final DetectedLibraryRoot myDetectedRoot;
    private final Map<LibraryRootType, String> myRootTypeNames;
    private LibraryRootType mySelectedRootType;

    SuggestedChildRootInfo(VirtualFile rootCandidate, DetectedLibraryRoot detectedRoot, Map<LibraryRootType, String> rootTypeNames) {
        this.myRootCandidate = rootCandidate;
        this.myDetectedRoot = detectedRoot;
        this.myRootTypeNames = rootTypeNames;
        this.mySelectedRootType = detectedRoot.getTypes().get(0);
    }

    public VirtualFile getRootCandidate() {
        return this.myRootCandidate;
    }

    public DetectedLibraryRoot getDetectedRoot() {
        return this.myDetectedRoot;
    }

    public String getRootTypeName(LibraryRootType type) {
        return this.myRootTypeNames.get(type);
    }

    public LibraryRootType getSelectedRootType() {
        return this.mySelectedRootType;
    }

    public void setSelectedRootType(String selectedRootType) {
        for (LibraryRootType type : this.myDetectedRoot.getTypes()) {
            if (!this.getRootTypeName(type).equals(selectedRootType)) continue;
            this.mySelectedRootType = type;
            break;
        }
    }

    public String[] getRootTypeNames() {
        String[] types = ArrayUtil.toStringArray(this.myRootTypeNames.values());
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        return types;
    }
}

