/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.DetectedRootsChooserDialog;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootDetectionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraryEditor.RootDetectionUtil");

    private RootDetectionUtil() {
    }

    @NotNull
    public static List<OrderRoot> detectRoots(@NotNull Collection<VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project, @NotNull LibraryRootsComponentDescriptor rootsComponentDescriptor) {
        if (rootCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        if (rootsComponentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        List<OrderRoot> list = RootDetectionUtil.detectRoots(rootCandidates, parentComponent, project, rootsComponentDescriptor.getRootsDetector(), rootsComponentDescriptor.getRootTypes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<OrderRoot> detectRoots(final @NotNull Collection<VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project, final @NotNull LibraryRootsDetector detector, @NotNull OrderRootType[] rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
        if (rootCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        if (rootTypesAllowedToBeSelectedByUserIfNothingIsDetected == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        final ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        final ArrayList<SuggestedChildRootInfo> suggestedRoots = new ArrayList<SuggestedChildRootInfo>();
        new Task.Modal(project, "Scanning for Roots", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil$1", "run"));
                }
                try {
                    for (VirtualFile rootCandidate : rootCandidates) {
                        Collection<DetectedLibraryRoot> roots = detector.detectRoots(rootCandidate, indicator);
                        if (!roots.isEmpty() && RootDetectionUtil.allRootsHaveOneTypeAndEqualTo(roots, rootCandidate)) {
                            for (DetectedLibraryRoot root : roots) {
                                LibraryRootType libraryRootType = root.getTypes().get(0);
                                result.add(new OrderRoot(root.getFile(), libraryRootType.getType(), libraryRootType.isJarDirectory()));
                            }
                            continue;
                        }
                        for (DetectedLibraryRoot root : roots) {
                            HashMap<LibraryRootType, String> names = new HashMap<LibraryRootType, String>();
                            for (LibraryRootType type : root.getTypes()) {
                                String typeName = detector.getRootTypeName(type);
                                LOG.assertTrue(typeName != null, (Object)("Unexpected root type " + type.getType().name() + (type.isJarDirectory() ? " (jar directory)" : "") + ", detectors: " + detector));
                                names.put(type, typeName);
                            }
                            suggestedRoots.add(new SuggestedChildRootInfo(rootCandidate, root, names));
                        }
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        }.queue();
        if (!suggestedRoots.isEmpty()) {
            DetectedRootsChooserDialog dialog = parentComponent != null ? new DetectedRootsChooserDialog(parentComponent, suggestedRoots) : new DetectedRootsChooserDialog(project, suggestedRoots);
            dialog.show();
            if (!dialog.isOK()) {
                List<OrderRoot> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
                }
                return list;
            }
            for (SuggestedChildRootInfo suggestedChildRootInfo : dialog.getChosenRoots()) {
                LibraryRootType selectedRootType = suggestedChildRootInfo.getSelectedRootType();
                result.add(new OrderRoot(suggestedChildRootInfo.getDetectedRoot().getFile(), selectedRootType.getType(), selectedRootType.isJarDirectory()));
            }
        }
        if (result.isEmpty() && rootTypesAllowedToBeSelectedByUserIfNothingIsDetected.length > 0) {
            void var11_20;
            HashMap<String, Pair> types = new HashMap<String, Pair>();
            for (OrderRootType orderRootType : rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
                for (boolean isJarDirectory : new boolean[]{false, true}) {
                    String typeName = detector.getRootTypeName(new LibraryRootType(orderRootType, isJarDirectory));
                    if (typeName == null) continue;
                    types.put(typeName, Pair.create((Object)orderRootType, (Object)isJarDirectory));
                }
            }
            LOG.assertTrue(!types.isEmpty(), (Object)("No allowed root types found for " + detector));
            ArrayList<String> arrayList = new ArrayList<String>(types.keySet());
            String title = "Choose Categories of Selected Files";
            String description = XmlStringUtil.wrapInHtml((CharSequence)(ApplicationNamesInfo.getInstance().getProductName() + " cannot determine what kind of files the chosen items contain.<br>" + "Choose the appropriate categories from the list."));
            if (parentComponent != null) {
                ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(parentComponent, arrayList, title, description);
            } else {
                ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(project, (List<String>)arrayList, title, description);
            }
            for (String rootType : var11_20.showAndGetResult()) {
                Pair pair = (Pair)types.get(rootType);
                for (VirtualFile candidate : rootCandidates) {
                    result.add(new OrderRoot(candidate, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                }
            }
        }
        ArrayList<OrderRoot> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        return arrayList;
    }

    private static boolean allRootsHaveOneTypeAndEqualTo(Collection<DetectedLibraryRoot> roots, VirtualFile candidate) {
        for (DetectedLibraryRoot root : roots) {
            if (root.getTypes().size() <= 1 && root.getFile().equals(candidate)) continue;
            return false;
        }
        return true;
    }

    private static class ChooseRootTypeElementsDialog
    extends ChooseElementsDialog<String> {
        public ChooseRootTypeElementsDialog(Project project, List<String> names, String title, String description) {
            super(project, names, title, description, true);
        }

        private ChooseRootTypeElementsDialog(Component parent, List<String> names, String title, String description) {
            super(parent, names, title, description, true);
        }

        @Override
        protected String getItemText(String item) {
            return item;
        }

        @Override
        @Nullable
        protected Icon getItemIcon(String item) {
            return null;
        }
    }
}

