/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooserBasedAttachRootButtonDescriptor
extends AttachRootButtonDescriptor {
    public ChooserBasedAttachRootButtonDescriptor(@NotNull OrderRootType rootType, @NotNull String buttonText) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/ui/ChooserBasedAttachRootButtonDescriptor", "<init>"));
        }
        if (buttonText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/libraries/ui/ChooserBasedAttachRootButtonDescriptor", "<init>"));
        }
        super(rootType, buttonText);
    }

    public FileChooserDescriptor createChooserDescriptor() {
        return FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
    }

    public abstract String getChooserTitle(@Nullable String var1);

    public abstract String getChooserDescription();

    @Override
    public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/ui/ChooserBasedAttachRootButtonDescriptor", "selectFiles"));
        }
        if (libraryEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/libraries/ui/ChooserBasedAttachRootButtonDescriptor", "selectFiles"));
        }
        FileChooserDescriptor chooserDescriptor = this.createChooserDescriptor();
        chooserDescriptor.setTitle(this.getChooserTitle(libraryEditor.getName()));
        chooserDescriptor.setDescription(this.getChooserDescription());
        if (contextModule != null) {
            chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)contextModule);
        }
        return FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)parent, (Project)(contextModule != null ? contextModule.getProject() : null), (VirtualFile)initialSelection);
    }
}

