/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassPathStorageUtil {
    @NonNls
    public static final String DEFAULT_STORAGE = "default";
    @NonNls
    public static final String CLASSPATH_OPTION = "classpath";

    public static boolean isDefaultStorage(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/storage/ClassPathStorageUtil", "isDefaultStorage"));
        }
        String storageType = ClassPathStorageUtil.getStorageType(module);
        return storageType.equals(DEFAULT_STORAGE);
    }

    @NotNull
    public static String getStorageType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/storage/ClassPathStorageUtil", "getStorageType"));
        }
        String id = module.getOptionValue(CLASSPATH_OPTION);
        String string = id == null ? DEFAULT_STORAGE : id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClassPathStorageUtil", "getStorageType"));
        }
        return string;
    }
}

