/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class RootIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootIndex");
    private static final DirectoryInfo NULL_INFO = DirectoryInfo.createNew();
    private final Set<VirtualFile> myProjectExcludedRoots;
    private final MultiMap<String, VirtualFile> myPackagePrefixRoots;
    private final Map<String, List<VirtualFile>> myDirectoriesByPackageNameCache;
    private final Map<VirtualFile, DirectoryInfo> myInfoCache;
    private final List<JpsModuleSourceRootType<?>> myRootTypes;
    private final TObjectIntHashMap<JpsModuleSourceRootType<?>> myRootTypeId;

    RootIndex(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/RootIndex", "<init>"));
        }
        this.myProjectExcludedRoots = ContainerUtil.newHashSet();
        this.myPackagePrefixRoots = new MultiMap<String, VirtualFile>(){

            protected Collection<VirtualFile> createCollection() {
                return ContainerUtil.newLinkedHashSet();
            }
        };
        this.myDirectoriesByPackageNameCache = ContainerUtil.newConcurrentMap();
        this.myInfoCache = ContainerUtil.newConcurrentMap();
        this.myRootTypes = ContainerUtil.newArrayList();
        this.myRootTypeId = new TObjectIntHashMap();
        RootInfo info = this.buildRootInfo(project);
        Set<VirtualFile> allRoots = info.getAllRoots();
        for (VirtualFile root : allRoots) {
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            Pair pair = hierarchy == null ? new Pair(null, null) : info.calcDirectoryInfo(root, hierarchy);
            this.cacheInfos(root, root, (DirectoryInfo)pair.first);
            this.myPackagePrefixRoots.putValue(pair.second, (Object)root);
            if (!info.shouldMarkAsProjectExcluded(root, hierarchy)) continue;
            this.myProjectExcludedRoots.add(root);
        }
    }

    /*
     * WARNING - void declaration
     */
    private RootInfo buildRootInfo(Project project) {
        RootInfo info = new RootInfo();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile[] contentRoots;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            OrderEntry[] orderEntries = moduleRootManager.getOrderEntries();
            ContentEntry[] contentEntries = moduleRootManager.getContentEntries();
            for (VirtualFile virtualFile : contentRoots = moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(virtualFile)) continue;
                info.contentRootOf.put(virtualFile, module);
            }
            for (VirtualFile virtualFile : contentEntries) {
                if (!(virtualFile instanceof ContentEntryImpl) || !((ContentEntryImpl)virtualFile).isDisposed()) {
                    for (VirtualFile virtualFile2 : virtualFile.getExcludeFolderFiles()) {
                        info.excludedFromModule.put(virtualFile2, module);
                    }
                }
                for (VirtualFile virtualFile3 : virtualFile.getSourceFolders()) {
                    VirtualFile sourceFolderRoot = virtualFile3.getFile();
                    if (sourceFolderRoot == null) continue;
                    info.rootTypeId.put((Object)sourceFolderRoot, this.getRootTypeId(virtualFile3.getRootType()));
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module);
                    info.packagePrefix.put(sourceFolderRoot, virtualFile3.getPackagePrefix());
                }
            }
            for (VirtualFile virtualFile : orderEntries) {
                Library library;
                if (virtualFile instanceof ModuleOrderEntry) {
                    void var18_32;
                    Module depModule = ((ModuleOrderEntry)virtualFile).getModule();
                    if (depModule != null) {
                        VirtualFile[] importedClassRoots;
                        for (VirtualFile importedClassRoot : importedClassRoots = OrderEnumerator.orderEntries((Module)depModule).exportedOnly().recursively().classes().usingCache().getRoots()) {
                            info.depEntries.putValue((Object)importedClassRoot, (Object)virtualFile);
                        }
                    }
                    VirtualFile[] arr$ = virtualFile.getFiles(OrderRootType.SOURCES);
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var18_32 < len$) {
                        VirtualFile sourceRoot = arr$[var18_32];
                        info.depEntries.putValue((Object)sourceRoot, (Object)virtualFile);
                        ++var18_32;
                    }
                    continue;
                }
                if (!(virtualFile instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)virtualFile;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libSourceRootEntries.putValue((Object)sourceRoot, (Object)virtualFile);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    info.classAndSourceRoots.add(classRoot);
                    info.libClassRootEntries.putValue((Object)classRoot, (Object)virtualFile);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(virtualFile instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)virtualFile).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    info.excludedFromLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : sourceRoots) {
                    info.sourceOfLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : classRoots) {
                    info.classOfLibraries.putValue((Object)root, (Object)library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)project)) {
            Collections.addAll(info.excludedFromProject, directoryIndexExcludePolicy.getExcludeRootsForProject());
        }
        return info;
    }

    public void checkConsistency() {
        for (VirtualFile file : this.myProjectExcludedRoots) {
            assert (file.exists()) : file.getPath() + " does not exist";
        }
        for (VirtualFile file : this.myPackagePrefixRoots.values()) {
            assert (file.exists()) : file.getPath() + " does not exist";
        }
    }

    private int getRootTypeId(JpsModuleSourceRootType<?> rootType) {
        if (this.myRootTypeId.containsKey(rootType)) {
            return this.myRootTypeId.get(rootType);
        }
        int id = this.myRootTypes.size();
        if (id > 63) {
            LOG.error("Too many different types of module source roots (" + id + ") registered: " + this.myRootTypes);
        }
        this.myRootTypes.add(rootType);
        this.myRootTypeId.put(rootType, id);
        return id;
    }

    @Nullable
    public DirectoryInfo getInfoForDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForDirectory"));
        }
        if (!dir.isValid()) {
            return null;
        }
        if (!dir.isDirectory()) {
            return this.myInfoCache.get(dir);
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            DirectoryInfo info = this.myInfoCache.get(root);
            if (info != null) {
                if (dir != root) {
                    this.cacheInfos(dir, root, info);
                }
                return info == NULL_INFO ? null : info;
            }
            if (!FileTypeManager.getInstance().isFileIgnored(root)) continue;
            return this.cacheInfos(dir, root, null);
        }
        return this.cacheInfos(dir, null, null);
    }

    @Nullable
    DirectoryInfo cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @Nullable DirectoryInfo info) {
        while (dir != null) {
            this.myInfoCache.put(dir, info == null ? NULL_INFO : info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        return info;
    }

    public boolean isProjectExcludeRoot(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/RootIndex", "isProjectExcludeRoot"));
        }
        return this.myProjectExcludedRoots.contains(dir);
    }

    @NotNull
    List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
        }
        List result = this.myDirectoriesByPackageNameCache.get(packageName);
        if (result == null) {
            result = ContainerUtil.newSmartList((Object[])new Object[0]);
            if (StringUtil.isNotEmpty((String)packageName) && !packageName.startsWith(".")) {
                String shortName = StringUtil.getShortName((String)packageName);
                for (VirtualFile parentDir : this.getDirectoriesByPackageName(StringUtil.getPackageName((String)packageName), true)) {
                    VirtualFile child = parentDir.findChild(shortName);
                    if (child == null || !child.isDirectory() || this.getInfoForDirectory(child) == null || !packageName.equals(this.getPackageName(child))) continue;
                    result.add(child);
                }
            }
            result.addAll(this.myPackagePrefixRoots.get((Object)packageName));
            if (!result.isEmpty()) {
                this.myDirectoriesByPackageNameCache.put(packageName, result);
            }
        }
        if (includeLibrarySources) {
            List list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
            }
            return list;
        }
        List list = ContainerUtil.filter((Collection)result, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                DirectoryInfo info = RootIndex.this.getInfoForDirectory(file);
                return info != null && (!info.isInLibrarySource() || info.isInModuleSource() || info.hasLibraryClassRoot());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
        }
        return list;
    }

    @Nullable
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/RootIndex", "getPackageName"));
        }
        if (dir.isDirectory()) {
            if (FileTypeManager.getInstance().isFileIgnored(dir)) {
                return null;
            }
            for (Map.Entry entry : this.myPackagePrefixRoots.entrySet()) {
                if (!((Collection)entry.getValue()).contains(dir)) continue;
                return (String)entry.getKey();
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    @Nullable
    protected static String getPackageNameForSubdir(String parentPackageName, String subdirName) {
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo directoryInfo) {
        if (directoryInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/RootIndex", "getSourceRootType"));
        }
        return this.myRootTypes.get(directoryInfo.getSourceRootTypeId());
    }

    boolean handleAfterEvent(List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file != null && !file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static List<VirtualFile> getHierarchy(VirtualFile dir, Set<VirtualFile> allRoots, RootInfo info) {
        ArrayList hierarchy = ContainerUtil.newArrayList();
        boolean hasContentRoots = false;
        while (dir != null) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && FileTypeManager.getInstance().isFileIgnored(dir)) {
                return null;
            }
            if (allRoots.contains(dir)) {
                hierarchy.add(dir);
            }
            dir = dir.getParent();
        }
        return hierarchy;
    }

    private static class RootInfo {
        @NotNull
        final LinkedHashSet<VirtualFile> classAndSourceRoots = ContainerUtil.newLinkedHashSet();
        @NotNull
        final Map<VirtualFile, Module> contentRootOf = ContainerUtil.newHashMap();
        @NotNull
        final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        final TObjectIntHashMap<VirtualFile> rootTypeId = new TObjectIntHashMap();
        @NotNull
        final MultiMap<VirtualFile, OrderEntry> libClassRootEntries = MultiMap.createSmartList();
        @NotNull
        final MultiMap<VirtualFile, OrderEntry> libSourceRootEntries = MultiMap.createSmartList();
        @NotNull
        final MultiMap<VirtualFile, OrderEntry> depEntries = MultiMap.createSmartList();
        @NotNull
        final MultiMap<VirtualFile, Library> excludedFromLibraries = MultiMap.createSmartList();
        @NotNull
        final MultiMap<VirtualFile, Library> classOfLibraries = MultiMap.createSmartList();
        @NotNull
        final MultiMap<VirtualFile, Library> sourceOfLibraries = MultiMap.createSmartList();
        @NotNull
        final Set<VirtualFile> excludedFromProject = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> excludedFromModule = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> packagePrefix = ContainerUtil.newHashMap();

        private RootInfo() {
        }

        Set<VirtualFile> getAllRoots() {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            result.addAll(this.classAndSourceRoots);
            result.addAll(this.contentRootOf.keySet());
            result.addAll(this.excludedFromLibraries.keySet());
            result.addAll(this.excludedFromModule.keySet());
            result.addAll(this.excludedFromProject);
            return result;
        }

        private boolean shouldMarkAsProjectExcluded(VirtualFile root, @Nullable List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                return false;
            }
            if (!this.excludedFromProject.contains(root) && !this.excludedFromModule.containsKey(root)) {
                return false;
            }
            return ContainerUtil.find(hierarchy, (Condition)new Condition<VirtualFile>(){

                public boolean value(VirtualFile ancestor) {
                    return RootInfo.this.contentRootOf.containsKey(ancestor);
                }
            }) == null;
        }

        @Nullable
        private VirtualFile findModuleRootInfo(List<VirtualFile> hierarchy) {
            for (VirtualFile root : hierarchy) {
                Module module = this.contentRootOf.get(root);
                Module excludedFrom = this.excludedFromModule.get(root);
                if (module != null && excludedFrom != module) {
                    return root;
                }
                if (!this.excludedFromProject.contains(root) && excludedFrom == null && root.isDirectory()) continue;
                return null;
            }
            return null;
        }

        @Nullable
        private VirtualFile findLibraryRootInfo(List<VirtualFile> hierarchy, boolean source) {
            HashSet librariesToIgnore = ContainerUtil.newHashSet();
            for (VirtualFile root : hierarchy) {
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)root));
                if (source && this.libSourceRootEntries.containsKey((Object)root) && (!this.sourceOfLibraries.containsKey((Object)root) || !librariesToIgnore.containsAll(this.sourceOfLibraries.get((Object)root)))) {
                    return root;
                }
                if (source || !this.libClassRootEntries.containsKey((Object)root) || this.classOfLibraries.containsKey((Object)root) && librariesToIgnore.containsAll(this.classOfLibraries.get((Object)root))) continue;
                return root;
            }
            return null;
        }

        @NotNull
        private Pair<DirectoryInfo, String> calcDirectoryInfo(VirtualFile root, @NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcDirectoryInfo"));
            }
            VirtualFile moduleContentRoot = this.findModuleRootInfo(hierarchy);
            VirtualFile libraryClassRoot = this.findLibraryRootInfo(hierarchy, false);
            VirtualFile librarySourceRoot = this.findLibraryRootInfo(hierarchy, true);
            if (moduleContentRoot == null && libraryClassRoot == null && librarySourceRoot == null) {
                Pair pair = new Pair(null, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcDirectoryInfo"));
                }
                return pair;
            }
            VirtualFile sourceRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
            VirtualFile moduleSourceRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
            boolean inModuleSources = moduleSourceRoot != null;
            boolean inLibrarySource = librarySourceRoot != null;
            int typeId = moduleSourceRoot != null ? this.rootTypeId.get((Object)moduleSourceRoot) : 0;
            OrderEntry[] entries = this.getOrderEntries(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
            DirectoryInfo directoryInfo = new DirectoryInfo(this.contentRootOf.get(moduleContentRoot), moduleContentRoot, sourceRoot, libraryClassRoot, (byte)DirectoryInfo.createSourceRootTypeData(inModuleSources, inLibrarySource, typeId), entries);
            String packagePrefix = this.calcPackagePrefix(root, hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
            Pair pair = Pair.create((Object)directoryInfo, (Object)packagePrefix);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcDirectoryInfo"));
            }
            return pair;
        }

        private String calcPackagePrefix(VirtualFile root, List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            VirtualFile packageRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
            String prefix = this.packagePrefix.get(packageRoot);
            if (prefix != null && packageRoot != root) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)packageRoot, (char)'.');
                prefix = StringUtil.isEmpty((String)prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            for (VirtualFile root : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get((Object)root).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return root;
                }
                if (root == libraryClassRoot || root == librarySourceRoot) {
                    return root;
                }
                if (root != moduleContentRoot || this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        private LinkedHashSet<OrderEntry> getDependencyOrderEntries(List<VirtualFile> hierarchy) {
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            for (VirtualFile root : hierarchy) {
                orderEntries.addAll(this.depEntries.get((Object)root));
            }
            return orderEntries;
        }

        private LinkedHashSet<OrderEntry> getLibraryOrderEntries(List<VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot) {
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            for (VirtualFile root : hierarchy) {
                if (root == libraryClassRoot && !this.sourceRootOf.containsKey((Object)root)) {
                    orderEntries.addAll(this.libClassRootEntries.get((Object)root));
                }
                if (root == librarySourceRoot && libraryClassRoot == null) {
                    orderEntries.addAll(this.libSourceRootEntries.get((Object)root));
                }
                if (!this.libClassRootEntries.containsKey((Object)root) && (!this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null)) continue;
                break;
            }
            return orderEntries;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(List<VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot) {
            if (moduleContentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile root : hierarchy) {
                if (this.sourceRootOf.get((Object)root).contains(module)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!this.libClassRootEntries.containsKey((Object)root)) continue;
                return null;
            }
            return null;
        }

        private OrderEntry[] getOrderEntries(List<VirtualFile> hierarchy, @Nullable VirtualFile moduleContentRoot, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot) {
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            orderEntries.addAll(this.getLibraryOrderEntries(hierarchy, libraryClassRoot, librarySourceRoot));
            orderEntries.addAll(this.getDependencyOrderEntries(hierarchy));
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull((Collection)orderEntries, (Object)this.getModuleSourceEntry(hierarchy, moduleContentRoot));
            }
            if (orderEntries.isEmpty()) {
                return null;
            }
            OrderEntry[] array = orderEntries.toArray(new OrderEntry[orderEntries.size()]);
            Arrays.sort(array, DirectoryInfo.BY_OWNER_MODULE);
            return array;
        }
    }
}

