/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater");
    private final Project myProject;
    private final FilePropertyPusher[] myPushers;
    private final FilePropertyPusher[] myFilePushers;

    public static PushedFilePropertiesUpdater getInstance(Project project) {
        return (PushedFilePropertiesUpdater)project.getComponent(PushedFilePropertiesUpdater.class);
    }

    public PushedFilePropertiesUpdater(final Project project, final MessageBus bus) {
        this.myProject = project;
        this.myPushers = (FilePropertyPusher[])Extensions.getExtensions(FilePropertyPusher.EP_NAME);
        this.myFilePushers = (FilePropertyPusher[])ContainerUtil.findAllAsArray((Object[])this.myPushers, (Condition)new Condition<FilePropertyPusher>(){

            public boolean value(FilePropertyPusher pusher) {
                return !pusher.pushDirectoriesOnly();
            }
        });
        StartupManager.getInstance((Project)project).registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                PushedFilePropertiesUpdater.this.pushAll(PushedFilePropertiesUpdater.this.myPushers);
                LOG.info("File properties pushed in " + (System.currentTimeMillis() - l) + " ms");
                MessageBusConnection connection = bus.connect();
                connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                    public void rootsChanged(ModuleRootEvent event) {
                        PushedFilePropertiesUpdater.this.pushAll(PushedFilePropertiesUpdater.this.myPushers);
                        for (FilePropertyPusher pusher : PushedFilePropertiesUpdater.this.myPushers) {
                            pusher.afterRootsChanged(project);
                        }
                    }
                });
                connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileAdapter(){

                    public void fileCreated(@NotNull VirtualFileEvent event) {
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdater$2$2", "fileCreated"));
                        }
                        VirtualFile file = event.getFile();
                        FilePropertyPusher[] pushers = file.isDirectory() ? PushedFilePropertiesUpdater.this.myPushers : PushedFilePropertiesUpdater.this.myFilePushers;
                        PushedFilePropertiesUpdater.this.pushRecursively(file, project, pushers);
                    }

                    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                        FilePropertyPusher[] pushers;
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdater$2$2", "fileMoved"));
                        }
                        VirtualFile file = event.getFile();
                        for (FilePropertyPusher pusher : pushers = file.isDirectory() ? PushedFilePropertiesUpdater.this.myPushers : PushedFilePropertiesUpdater.this.myFilePushers) {
                            file.putUserData(pusher.getFileDataKey(), null);
                        }
                        PushedFilePropertiesUpdater.this.pushRecursively(file, project, pushers);
                    }
                }));
                for (final FilePropertyPusher pusher : PushedFilePropertiesUpdater.this.myPushers) {
                    pusher.initExtra(project, bus, new FilePropertyPusher.Engine(){

                        @Override
                        public void pushAll() {
                            PushedFilePropertiesUpdater.this.pushAll(pusher);
                        }

                        @Override
                        public void pushRecursively(VirtualFile file, Project project) {
                            PushedFilePropertiesUpdater.this.pushRecursively(file, project, pusher);
                        }
                    });
                }
            }
        });
    }

    public void pushRecursively(VirtualFile dir, Project project, final FilePropertyPusher ... pushers) {
        if (pushers.length == 0) {
            return;
        }
        ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContentUnderDirectory(dir, new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                PushedFilePropertiesUpdater.this.applyPushersToFile(fileOrDir, pushers, null);
                return true;
            }
        });
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<T> pusher, T moduleValue) {
        T value = pusher.getImmediateValue(project, dir);
        if (value != null) {
            return value;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            return PushedFilePropertiesUpdater.findPusherValuesUpwards(project, parent, pusher);
        }
        T projectValue = pusher.getImmediateValue(project, null);
        return projectValue != null ? projectValue : pusher.getDefaultValue();
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<T> pusher) {
        Object userValue = dir.getUserData(pusher.getFileDataKey());
        if (userValue != null) {
            return (T)userValue;
        }
        T value = pusher.getImmediateValue(project, dir);
        if (value != null) {
            return value;
        }
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            return PushedFilePropertiesUpdater.findPusherValuesUpwards(project, parent, pusher);
        }
        T projectValue = pusher.getImmediateValue(project, null);
        return projectValue != null ? projectValue : pusher.getDefaultValue();
    }

    public void pushAll(final FilePropertyPusher ... pushers) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.pushState();
            indicator.setText("Initializing file system cache...");
        }
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        for (int i1 = 0; i1 < modules.length; ++i1) {
            if (indicator != null) {
                indicator.setFraction((double)i1 / (double)modules.length);
            }
            Module module = modules[i1];
            final Object[] moduleValues = new Object[pushers.length];
            for (int i = 0; i < moduleValues.length; ++i) {
                moduleValues[i] = pushers[i].getImmediateValue(module);
            }
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModuleFileIndex index = rootManager.getFileIndex();
            for (VirtualFile root : rootManager.getContentRoots()) {
                index.iterateContentUnderDirectory(root, new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        PushedFilePropertiesUpdater.this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                        return true;
                    }
                });
            }
        }
        if (indicator != null) {
            indicator.popState();
        }
    }

    private void applyPushersToFile(VirtualFile fileOrDir, FilePropertyPusher[] pushers, Object[] moduleValues) {
        Object pusher = null;
        try {
            boolean isDir = fileOrDir.isDirectory();
            int pushersLength = pushers.length;
            for (int i = 0; i < pushersLength; ++i) {
                pusher = pushers[i];
                if (!isDir && (pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir)) || isDir && !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
                PushedFilePropertiesUpdater.findAndUpdateValue(this.myProject, fileOrDir, pusher, moduleValues != null ? moduleValues[i] : null);
            }
        }
        catch (AbstractMethodError ame) {
            if (pusher != null) {
                throw new ExtensionException(pusher.getClass());
            }
            throw ame;
        }
    }

    public static <T> void findAndUpdateValue(Project project, VirtualFile fileOrDir, FilePropertyPusher<T> pusher, T moduleValue) {
        T value = PushedFilePropertiesUpdater.findPusherValuesUpwards(project, fileOrDir, pusher, moduleValue);
        PushedFilePropertiesUpdater.updateValue(fileOrDir, value, pusher);
    }

    private static <T> void updateValue(VirtualFile fileOrDir, T value, FilePropertyPusher<T> pusher) {
        Object oldValue = fileOrDir.getUserData(pusher.getFileDataKey());
        if (value != oldValue) {
            fileOrDir.putUserData(pusher.getFileDataKey(), value);
            try {
                pusher.persistAttribute(fileOrDir, value);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

