/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 3, true);

    public static void pushLanguageLevel(Project project) {
        PushedFilePropertiesUpdater.getInstance(project).pushAll(new JavaLanguageLevelPusher());
    }

    @Override
    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "initExtra"));
        }
    }

    @Override
    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key key = LanguageLevel.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getFileDataKey"));
        }
        return key;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return true;
    }

    @Override
    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getDefaultValue"));
        }
        return languageLevel;
    }

    @Override
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getImmediateValue"));
        }
        return null;
    }

    @Override
    public LanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getImmediateValue"));
        }
        return LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "acceptsFile"));
        }
        return false;
    }

    @Override
    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "acceptsDirectory"));
        }
        return ProjectFileIndex.SERVICE.getInstance((Project)project).isInSourceContent(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAttribute(@NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "persistAttribute"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "persistAttribute"));
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        oStream.close();
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !StdFileTypes.JAVA.equals(child.getFileType())) continue;
            FileBasedIndex.getInstance().requestReindex(child);
        }
    }

    @Override
    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "afterRootsChanged"));
        }
    }
}

