/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.file.exclude.ProjectFileExclusionManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;
    protected final ProjectFileExclusionManager myExclusionManager;

    public FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager, @NotNull Project project) {
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
        this.myExclusionManager = ProjectFileExclusionManager.SERVICE.getInstance((Project)project);
    }

    @Nullable
    protected DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        if (!file.isDirectory() && file.getParent() == null) {
            return null;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(file);
        if (info != null) {
            return info;
        }
        if (!file.isDirectory() && (dir = file.getParent()) != null) {
            return this.myDirectoryIndex.getInfoForDirectory(dir);
        }
        return null;
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/FileIndexBase", "isContentSourceFile"));
        }
        return !file.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file) && this.isInSourceContent(file);
    }
}

