/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectoryInfo {
    public static final int MAX_ROOT_TYPE_ID = 63;
    private final Module module;
    private final VirtualFile libraryClassRoot;
    private final VirtualFile contentRoot;
    private final VirtualFile sourceRoot;
    private static final byte MODULE_SOURCE_FLAG = 1;
    private static final byte LIBRARY_SOURCE_FLAG = 2;
    private final byte sourceRootTypeData;
    private final OrderEntry[] orderEntries;
    private static final ArrayFactory<OrderEntry> ORDER_ENTRY_ARRAY_FACTORY = new ArrayFactory<OrderEntry>(){

        @NotNull
        public OrderEntry[] create(int count) {
            OrderEntry[] orderEntryArray = count == 0 ? OrderEntry.EMPTY_ARRAY : new OrderEntry[count];
            if (orderEntryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo$2", "create"));
            }
            return orderEntryArray;
        }
    };
    public static final Comparator<OrderEntry> BY_OWNER_MODULE = new Comparator<OrderEntry>(){

        @Override
        public int compare(OrderEntry o1, OrderEntry o2) {
            String name1 = o1.getOwnerModule().getName();
            String name2 = o2.getOwnerModule().getName();
            return name1.compareTo(name2);
        }
    };

    public static DirectoryInfo createNew() {
        return new DirectoryInfo(null, null, null, null, 0, null);
    }

    DirectoryInfo(Module module, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, byte sourceRootTypeData, OrderEntry[] orderEntries) {
        this.module = module;
        this.libraryClassRoot = libraryClassRoot;
        this.contentRoot = contentRoot;
        this.sourceRoot = sourceRoot;
        this.sourceRootTypeData = sourceRootTypeData;
        this.orderEntries = orderEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryInfo info = (DirectoryInfo)o;
        return this.sourceRootTypeData == info.sourceRootTypeData && Comparing.equal((Object)this.contentRoot, (Object)info.contentRoot) && Comparing.equal((Object)this.libraryClassRoot, (Object)info.libraryClassRoot) && Comparing.equal((Object)this.module, (Object)info.module) && Arrays.equals(this.orderEntries, info.orderEntries) && Comparing.equal((Object)this.sourceRoot, (Object)info.sourceRoot);
    }

    public int hashCode() {
        int result = this.module != null ? this.module.hashCode() : 0;
        result = 31 * result + (this.libraryClassRoot != null ? this.libraryClassRoot.hashCode() : 0);
        result = 31 * result + (this.contentRoot != null ? this.contentRoot.hashCode() : 0);
        result = 31 * result + (this.sourceRoot != null ? this.sourceRoot.hashCode() : 0);
        result = 31 * result + this.sourceRootTypeData;
        return result;
    }

    public String toString() {
        return "DirectoryInfo{module=" + this.getModule() + ", isInModuleSource=" + this.isInModuleSource() + ", rootTypeId=" + this.getSourceRootTypeId() + ", isInLibrarySource=" + this.isInLibrarySource() + ", libraryClassRoot=" + this.getLibraryClassRoot() + ", contentRoot=" + this.getContentRoot() + ", sourceRoot=" + this.getSourceRoot() + ", orderEntries=" + Arrays.toString(this.orderEntries) + "}";
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] entries = this.orderEntries;
        OrderEntry[] orderEntryArray = entries == null ? OrderEntry.EMPTY_ARRAY : entries;
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    @Nullable
    OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule) {
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryInfo", "findOrderEntryWithOwnerModule"));
        }
        OrderEntry[] entries = this.orderEntries;
        if (entries == null) {
            return null;
        }
        if (entries.length < 10) {
            for (OrderEntry entry : entries) {
                if (entry.getOwnerModule() != ownerModule) continue;
                return entry;
            }
            return null;
        }
        int index = Arrays.binarySearch(entries, DirectoryInfo.createFakeOrderEntry(ownerModule), BY_OWNER_MODULE);
        return index < 0 ? null : entries[index];
    }

    @NotNull
    List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule) {
        int lastIndex;
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryInfo", "findAllOrderEntriesWithOwnerModule"));
        }
        OrderEntry[] entries = this.orderEntries;
        if (entries == null) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "findAllOrderEntriesWithOwnerModule"));
            }
            return list;
        }
        if (entries.length == 1) {
            OrderEntry entry = entries[0];
            List<Object> list = entry.getOwnerModule() == ownerModule ? Arrays.asList(entries) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "findAllOrderEntriesWithOwnerModule"));
            }
            return list;
        }
        int index = Arrays.binarySearch(entries, DirectoryInfo.createFakeOrderEntry(ownerModule), BY_OWNER_MODULE);
        if (index < 0) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "findAllOrderEntriesWithOwnerModule"));
            }
            return list;
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries[firstIndex - 1].getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.length && entries[lastIndex].getOwnerModule() == ownerModule; ++lastIndex) {
        }
        OrderEntry[] subArray = new OrderEntry[lastIndex - firstIndex];
        System.arraycopy(entries, firstIndex, subArray, 0, lastIndex - firstIndex);
        List<OrderEntry> list = Arrays.asList(subArray);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "findAllOrderEntriesWithOwnerModule"));
        }
        return list;
    }

    @NotNull
    private static OrderEntry createFakeOrderEntry(final @NotNull Module ownerModule) {
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryInfo", "createFakeOrderEntry"));
        }
        OrderEntry orderEntry = new OrderEntry(){

            @NotNull
            public VirtualFile[] getFiles(OrderRootType type) {
                throw new IncorrectOperationException();
            }

            @NotNull
            public String[] getUrls(OrderRootType rootType) {
                throw new IncorrectOperationException();
            }

            @NotNull
            public String getPresentableName() {
                throw new IncorrectOperationException();
            }

            public boolean isValid() {
                throw new IncorrectOperationException();
            }

            @NotNull
            public Module getOwnerModule() {
                Module module = ownerModule;
                if (module == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo$1", "getOwnerModule"));
                }
                return module;
            }

            public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
                throw new IncorrectOperationException();
            }

            public int compareTo(OrderEntry o) {
                throw new IncorrectOperationException();
            }

            public boolean isSynthetic() {
                throw new IncorrectOperationException();
            }
        };
        if (orderEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "createFakeOrderEntry"));
        }
        return orderEntry;
    }

    OrderEntry[] calcNewOrderEntries(@NotNull OrderEntry[] orderEntries, @Nullable DirectoryInfo parentInfo, @Nullable OrderEntry[] oldParentEntries) {
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryInfo", "calcNewOrderEntries"));
        }
        OrderEntry[] newOrderEntries = orderEntries.length == 0 ? null : (this.orderEntries == null ? orderEntries : (parentInfo != null && oldParentEntries == this.orderEntries ? parentInfo.orderEntries : this.mergeWith(orderEntries)));
        return newOrderEntries;
    }

    @NotNull
    private OrderEntry[] mergeWith(@NotNull OrderEntry[] entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryInfo", "mergeWith"));
        }
        OrderEntry[] orderEntries = this.orderEntries;
        Object[] result = new OrderEntry[orderEntries.length + entries.length];
        int i = 0;
        int j = 0;
        int o = 0;
        while (i != orderEntries.length || j != entries.length) {
            OrderEntry m;
            OrderEntry orderEntry = m = i != orderEntries.length && (j == entries.length || BY_OWNER_MODULE.compare(orderEntries[i], entries[j]) < 0) ? orderEntries[i++] : entries[j++];
            if (o != 0 && m.equals(result[o - 1])) continue;
            result[o++] = m;
        }
        if (o != result.length) {
            result = (OrderEntry[])ArrayUtil.realloc((Object[])result, (int)o, ORDER_ENTRY_ARRAY_FACTORY);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "mergeWith"));
        }
        return result;
    }

    public VirtualFile getSourceRoot() {
        return this.sourceRoot;
    }

    public boolean hasSourceRoot() {
        return this.getSourceRoot() != null;
    }

    public VirtualFile getLibraryClassRoot() {
        return this.libraryClassRoot;
    }

    public boolean hasLibraryClassRoot() {
        return this.getLibraryClassRoot() != null;
    }

    public VirtualFile getContentRoot() {
        return this.contentRoot;
    }

    public boolean isInModuleSource() {
        return BitUtil.isSet((byte)this.sourceRootTypeData, (byte)1);
    }

    public boolean isInLibrarySource() {
        return BitUtil.isSet((byte)this.sourceRootTypeData, (byte)2);
    }

    public Module getModule() {
        return this.module;
    }

    private static <T> T iff(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    @NotNull
    public DirectoryInfo with(Module module, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, int sourceRootTypeData, OrderEntry[] orderEntries) {
        DirectoryInfo directoryInfo = new DirectoryInfo(DirectoryInfo.iff(module, this.module), DirectoryInfo.iff(contentRoot, this.contentRoot), DirectoryInfo.iff(sourceRoot, this.sourceRoot), DirectoryInfo.iff(libraryClassRoot, this.libraryClassRoot), sourceRootTypeData == 0 ? this.sourceRootTypeData : (byte)sourceRootTypeData, DirectoryInfo.iff(orderEntries, this.orderEntries));
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "with"));
        }
        return directoryInfo;
    }

    @NotNull
    public DirectoryInfo withInternedEntries(@NotNull OrderEntry[] orderEntries) {
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryInfo", "withInternedEntries"));
        }
        DirectoryInfo directoryInfo = new DirectoryInfo(this.module, this.contentRoot, this.sourceRoot, this.libraryClassRoot, this.sourceRootTypeData, orderEntries);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfo", "withInternedEntries"));
        }
        return directoryInfo;
    }

    void assertConsistency() {
        OrderEntry[] entries = this.getOrderEntries();
        for (int i = 1; i < entries.length; ++i) {
            assert (BY_OWNER_MODULE.compare(entries[i - 1], entries[i]) <= 0);
        }
    }

    public int getSourceRootTypeId() {
        return this.sourceRootTypeData >> 2;
    }

    public static int createSourceRootTypeData(boolean isInModuleSources, boolean isInLibrarySource, int moduleSourceRootTypeId) {
        if (moduleSourceRootTypeId > 63) {
            throw new IllegalArgumentException("Module source root type id " + moduleSourceRootTypeId + " exceeds the maximum allowable value (" + 63 + ")");
        }
        return (isInModuleSources ? 1 : 0) | (isInLibrarySource ? 2 : 0) | moduleSourceRootTypeId << 2;
    }
}

