/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.CommonBundle;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements NamedJDOMExternalizable,
ExportableApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectManagerImpl");
    public static final int CURRENT_FORMAT_VERSION = 4;
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private static final String ELEMENT_DEFAULT_PROJECT = "defaultProject";
    private ProjectImpl myDefaultProject;
    private Element myDefaultProjectRootElement;
    private final List<Project> myOpenProjects = new ArrayList<Project>();
    private Project[] myOpenProjectsArrayCache = new Project[0];
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<Project> myTestProjects = new THashSet();
    private final Map<VirtualFile, byte[]> mySavedCopies = new HashMap();
    private final TObjectLongHashMap<VirtualFile> mySavedTimestamps = new TObjectLongHashMap();
    private final Map<Project, List<Pair<VirtualFile, StateStorage>>> myChangedProjectFiles = new HashMap();
    private final Alarm myChangedFilesAlarm = new Alarm();
    private final List<Pair<VirtualFile, StateStorage>> myChangedApplicationFiles = new ArrayList<Pair<VirtualFile, StateStorage>>();
    private final AtomicInteger myReloadBlockCount = new AtomicInteger(0);
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed = false;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS = false;
    private static final int MAX_LEAKY_PROJECTS = 42;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(Project project) {
        List array = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            List<ProjectManagerListener> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
            }
            return list;
        }
        List list = array;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
        }
        return list;
    }

    public ProjectManagerImpl(VirtualFileManager virtualFileManager, RecentProjectsManagerBase recentProjectsManager, ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        Application app = ApplicationManager.getApplication();
        MessageBus messageBus = app.getMessageBus();
        messageBus.connect((Disposable)app).subscribe(StateStorage.STORAGE_TOPIC, (Object)new StateStorage.Listener(){

            public void storageFileChanged(@NotNull VirtualFileEvent event, @NotNull StateStorage storage) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl$1", "storageFileChanged"));
                }
                if (storage == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl$1", "storageFileChanged"));
                }
                VirtualFile file = event.getFile();
                if (!file.isDirectory() && !(event.getRequestor() instanceof StateStorage.SaveSession)) {
                    ProjectManagerImpl.this.saveChangedProjectFile(file, null, storage);
                }
            }
        });
        final ProjectManagerListener busPublisher = (ProjectManagerListener)messageBus.syncPublisher(TOPIC);
        this.addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(final Project project) {
                MessageBus messageBus = project.getMessageBus();
                MessageBusConnection connection = messageBus.connect((Disposable)project);
                connection.subscribe(StateStorage.STORAGE_TOPIC, (Object)new StateStorage.Listener(){

                    public void storageFileChanged(@NotNull VirtualFileEvent event, @NotNull StateStorage storage) {
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl$2$1", "storageFileChanged"));
                        }
                        if (storage == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl$2$1", "storageFileChanged"));
                        }
                        VirtualFile file = event.getFile();
                        if (!file.isDirectory() && !(event.getRequestor() instanceof StateStorage.SaveSession)) {
                            ProjectManagerImpl.this.saveChangedProjectFile(file, project, storage);
                        }
                    }
                });
                busPublisher.projectOpened(project);
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    listener.projectOpened(project);
                }
            }

            public void projectClosed(Project project) {
                busPublisher.projectClosed(project);
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    listener.projectClosed(project);
                }
            }

            public boolean canCloseProject(Project project) {
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    if (listener.canCloseProject(project)) continue;
                    return false;
                }
                return true;
            }

            public void projectClosing(Project project) {
                busPublisher.projectClosing(project);
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    listener.projectClosing(project);
                }
            }
        });
        this.registerExternalProjectFileListener(virtualFileManager);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Disposer.dispose((Disposable)this.myChangedFilesAlarm);
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl", "newProject"));
        }
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        ProjectImpl project = this.createProject(projectName, filePath, false, ApplicationManager.getApplication().isUnitTestMode());
        try {
            this.initProject(project, useDefaultProjectSettings ? (ProjectImpl)this.getDefaultProject() : null);
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    private static String message(Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            return message;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            return message + " (cause: " + causeMessage + ")";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectImpl project, @Nullable ProjectImpl template) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "initProject"));
        }
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null && !project.isDefault()) {
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project.getName()}));
            indicator.setIndeterminate(true);
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project);
        boolean succeed = false;
        try {
            if (template != null) {
                project.getStateStore().loadProjectFromTemplate(template);
            } else {
                project.getStateStore().load();
            }
            project.loadProjectComponents();
            project.init();
            succeed = true;
        }
        finally {
            if (!succeed) {
                ProjectManagerImpl.scheduleDispose(project);
            }
        }
    }

    private ProjectImpl createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault, boolean isOptimiseTestLoadSpeed) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl", "createProject"));
        }
        return isDefault ? new DefaultProject(this, "", isOptimiseTestLoadSpeed) : new ProjectImpl(this, new File(filePath).getAbsolutePath(), isOptimiseTestLoadSpeed, projectName);
    }

    private static void scheduleDispose(final ProjectImpl project) {
        if (project.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            Disposer.dispose((Disposable)project);
                        }
                    }
                });
            }
        });
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException, JDOMException, InvalidDataException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadProject"));
        }
        try {
            ProjectImpl project = this.createProject(null, filePath, false, false);
            this.initProject(project, null);
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
        }
        try {
            string = FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            String string2 = filePath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
        }
        return string;
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectManagerImpl.this.myDefaultProject = ProjectManagerImpl.this.createProject(null, "", true, ApplicationManager.getApplication().isUnitTestMode());
                        ProjectManagerImpl.this.initProject(ProjectManagerImpl.this.myDefaultProject, null);
                        ProjectManagerImpl.this.myDefaultProjectRootElement = null;
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                    }
                }
            });
        }
        ProjectImpl projectImpl = this.myDefaultProject;
        if (projectImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getDefaultProject"));
        }
        return projectImpl;
    }

    public Element getDefaultProjectRootElement() {
        return this.myDefaultProjectRootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object[] testProjects;
        List<Project> list = this.myOpenProjects;
        // MONITORENTER : list
        if (this.myOpenProjectsArrayCache.length != this.myOpenProjects.size()) {
            LOG.error("Open projects: " + this.myOpenProjects + "; cache: " + Arrays.asList(this.myOpenProjectsArrayCache));
        }
        if (this.myOpenProjectsArrayCache.length > 0 && this.myOpenProjectsArrayCache[0] != this.myOpenProjects.get(0)) {
            LOG.error("Open projects cache corrupted. Open projects: " + this.myOpenProjects + "; cache: " + Arrays.asList(this.myOpenProjectsArrayCache));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            // MONITOREXIT : list
            if (this.myOpenProjectsArrayCache != null) return this.myOpenProjectsArrayCache;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getOpenProjects"));
        }
        Object[] arr$ = testProjects = this.myTestProjects.toArray(new Project[this.myTestProjects.size()]);
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                Project[] projectArray = (Project[])ArrayUtil.mergeArrays((Object[])this.myOpenProjectsArrayCache, (Object[])testProjects);
                // MONITOREXIT : list
                if (projectArray != null) return projectArray;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getOpenProjects"));
            }
            Project project = arr$[i$];
            assert (!project.isDisposed()) : project;
            ++i$;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project) {
        List<Project> list = this.myOpenProjects;
        synchronized (list) {
            return ApplicationManager.getApplication().isUnitTestMode() && this.myTestProjects.contains(project) || this.myOpenProjects.contains(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openProject(final Project project) {
        if (ProjectManagerImpl.isLight(project)) {
            throw new AssertionError((Object)"must not open light project");
        }
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode() && !((ProjectEx)project).getStateStore().checkVersion()) {
            return false;
        }
        List<Project> list = this.myOpenProjects;
        synchronized (list) {
            if (this.myOpenProjects.contains(project)) {
                return false;
            }
            this.myOpenProjects.add(project);
            this.cacheOpenProjects();
        }
        this.fireProjectOpened(project);
        this.waitForFileWatcher(project);
        final StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project);
        boolean ok = this.myProgressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                startupManager.runStartupActivities();
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        startupManager.startCacheUpdate();
                    }
                });
                startupManager.runPostStartupActivitiesFromExtensions();
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        startupManager.runPostStartupActivities();
                    }
                });
            }
        }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true, project);
        if (!ok) {
            this.closeProject(project, false, false, true);
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
            startupManager.runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    TrackingPathMacroSubstitutor macroSubstitutor = ((ProjectEx)project).getStateStore().getStateStorageManager().getMacroSubstitutor();
                    if (macroSubstitutor != null) {
                        StorageUtil.notifyUnknownMacros(macroSubstitutor, project, null);
                    }
                }
            });
        }
        return true;
    }

    private void cacheOpenProjects() {
        this.myOpenProjectsArrayCache = this.myOpenProjects.toArray(new Project[this.myOpenProjects.size()]);
    }

    private void waitForFileWatcher(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "waitForFileWatcher"));
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        final FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational() || !watcher.isSettingRoots()) {
            return;
        }
        LOG.info("FW/roots waiting started");
        Task.Modal task = new Task.Modal(project, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl$7", "run"));
                }
                indicator.setIndeterminate(true);
                indicator.setText(ProjectBundle.message((String)"project.load.waiting.watcher", (Object[])new Object[0]));
                if (indicator instanceof ProgressWindow) {
                    ((ProgressWindow)indicator).setCancelButtonText(CommonBundle.message((String)"button.skip", (Object[])new Object[0]));
                }
                while (watcher.isSettingRoots() && !indicator.isCanceled()) {
                    TimeoutUtil.sleep((long)10L);
                }
                LOG.info("FW/roots waiting finished");
            }
        };
        this.myProgressManager.run((Task)task);
    }

    public Project loadAndOpenProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadAndOpenProject"));
        }
        final Project project = this.convertAndLoadProject(filePath);
        if (project == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!this.openProject(project)) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        return project;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(String filePath) throws IOException {
        Project project;
        String fp = ProjectManagerImpl.toCanonicalName(filePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(fp);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        try {
            project = this.loadProjectWithProgress(filePath);
            if (project == null) {
                return null;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
        if (!conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    conversionResult.postStartupActivity(project);
                }
            });
        }
        return project;
    }

    @Nullable
    private Project loadProjectWithProgress(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadProjectWithProgress"));
        }
        final ProjectImpl project = this.createProject(null, ProjectManagerImpl.toCanonicalName(filePath), false, false);
        try {
            this.myProgressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Project, IOException>(){

                @Nullable
                public Project compute() throws IOException {
                    ProjectManagerImpl.this.initProject(project, null);
                    return project;
                }
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true, (Project)project);
        }
        catch (StateStorageException e) {
            throw new IOException(e);
        }
        catch (ProcessCanceledException ignore) {
            return null;
        }
        return project;
    }

    private static void notifyProjectOpenFailed() {
        ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        WelcomeFrame.showIfNoProjectOpened();
    }

    private void registerExternalProjectFileListener(VirtualFileManager virtualFileManager) {
        virtualFileManager.addVirtualFileManagerListener(new VirtualFileManagerListener(){

            public void beforeRefreshStart(boolean asynchronous) {
            }

            public void afterRefreshFinish(boolean asynchronous) {
                ProjectManagerImpl.this.scheduleReloadApplicationAndProject();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void askToReloadProjectIfConfigFilesChangedExternally() {
        LOG.debug("[RELOAD] myReloadBlockCount = " + this.myReloadBlockCount.get());
        if (this.myReloadBlockCount.get() == 0) {
            HashSet<Project> projects;
            Map<Project, List<Pair<VirtualFile, StateStorage>>> map = this.myChangedProjectFiles;
            synchronized (map) {
                if (this.myChangedProjectFiles.isEmpty()) {
                    return;
                }
                projects = new HashSet<Project>(this.myChangedProjectFiles.keySet());
            }
            ArrayList<Project> projectsToReload = new ArrayList<Project>();
            for (Project project : projects) {
                if (!this.shouldReloadProject(project)) continue;
                projectsToReload.add(project);
            }
            for (Project projectToReload : projectsToReload) {
                this.reloadProjectImpl(projectToReload, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToReloadApplication() {
        try {
            final Application app = ApplicationManager.getApplication();
            if (app.isDisposed()) {
                boolean bl = false;
                return bl;
            }
            final HashSet<Pair<VirtualFile, StateStorage>> causes = new HashSet<Pair<VirtualFile, StateStorage>>(this.myChangedApplicationFiles);
            if (causes.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            final boolean[] reloadOk = new boolean[]{false};
            final LinkedHashSet components = new LinkedHashSet();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        reloadOk[0] = ((ApplicationImpl)app).getStateStore().reload(causes, components);
                    }
                    catch (StateStorageException e) {
                        Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    }
                    catch (IOException e) {
                        Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    }
                }
            });
            if (!reloadOk[0] && !components.isEmpty()) {
                String message = "Application components were changed externally and cannot be reloaded:\n";
                for (String component : components) {
                    message = message + component + "\n";
                }
                boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
                message = message + "Would you like to " + (canRestart ? "restart " : "shutdown ");
                if (Messages.showYesNoDialog((String)(message = message + ApplicationNamesInfo.getInstance().getProductName() + "?"), (String)"Application Configuration Reload", (Icon)Messages.getQuestionIcon()) == 0) {
                    for (Pair<VirtualFile, StateStorage> cause : causes) {
                        StateStorage stateStorage = (StateStorage)cause.getSecond();
                        if (!(stateStorage instanceof XmlElementStorage)) continue;
                        ((XmlElementStorage)stateStorage).disableSaving();
                    }
                    ApplicationManagerEx.getApplicationEx().restart(true);
                }
            }
            boolean bl = reloadOk[0];
            return bl;
        }
        finally {
            this.myChangedApplicationFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldReloadProject(final Project project) {
        String message;
        if (project.isDisposed()) {
            return false;
        }
        final HashSet<Pair<VirtualFile, StateStorage>> causes = new HashSet<Pair<VirtualFile, StateStorage>>();
        Map<Project, List<Pair<VirtualFile, StateStorage>>> map = this.myChangedProjectFiles;
        synchronized (map) {
            List<Pair<VirtualFile, StateStorage>> changes = this.myChangedProjectFiles.remove(project);
            if (changes != null) {
                causes.addAll(changes);
            }
            if (causes.isEmpty()) {
                return false;
            }
        }
        final boolean[] reloadOk = new boolean[]{false};
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("[RELOAD] Reloading project/components...");
                    reloadOk[0] = ((ProjectEx)project).getStateStore().reload(causes);
                }
                catch (StateStorageException e) {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                }
                catch (IOException e) {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                }
            }
        });
        if (reloadOk[0]) {
            return false;
        }
        if (causes.size() == 1) {
            message = ProjectBundle.message((String)"project.reload.external.change.single", (Object[])new Object[]{((VirtualFile)((Pair)causes.iterator().next()).first).getPresentableUrl()});
        } else {
            StringBuilder filesBuilder = new StringBuilder();
            boolean first = true;
            HashSet<String> alreadyShown = new HashSet<String>();
            for (Pair pair : causes) {
                String url = ((VirtualFile)pair.first).getPresentableUrl();
                if (alreadyShown.contains(url)) continue;
                if (alreadyShown.size() > 10) {
                    filesBuilder.append("\nand ").append(causes.size() - alreadyShown.size()).append(" more");
                    break;
                }
                if (!first) {
                    filesBuilder.append("\n");
                }
                first = false;
                filesBuilder.append(url);
                alreadyShown.add(url);
            }
            message = ProjectBundle.message((String)"project.reload.external.change.multiple", (Object[])new Object[]{filesBuilder.toString()});
        }
        return Messages.showTwoStepConfirmationDialog((String)message, (String)ProjectBundle.message((String)"project.reload.external.change.title", (Object[])new Object[0]), (String)"Reload project", (Icon)Messages.getQuestionIcon()) == 0;
    }

    @Override
    public boolean isFileSavedToBeReloaded(VirtualFile candidate) {
        return this.mySavedCopies.containsKey(candidate);
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
        this.myReloadBlockCount.incrementAndGet();
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
        if (this.myReloadBlockCount.decrementAndGet() == 0) {
            this.scheduleReloadApplicationAndProject();
        }
    }

    private void scheduleReloadApplicationAndProject() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ProjectManagerImpl.this.tryToReloadApplication()) {
                    return;
                }
                ProjectManagerImpl.this.askToReloadProjectIfConfigFilesChangedExternally();
            }
        }, ModalityState.NON_MODAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openTestProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "openTestProject"));
        }
        List<Project> list = this.myOpenProjects;
        synchronized (list) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            assert (!project.isDisposed()) : "Must not open already disposed project";
            this.myTestProjects.add(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Project> closeTestProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeTestProject"));
        }
        List<Project> list = this.myOpenProjects;
        synchronized (list) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            this.myTestProjects.remove(project);
            return this.myTestProjects;
        }
    }

    @Override
    public void saveChangedProjectFile(VirtualFile file, Project project) {
        if (file.exists()) {
            this.copyToTemp(file);
        }
        this.registerProjectToReload(project, file, null);
    }

    private void saveChangedProjectFile(VirtualFile file, @Nullable Project project, StateStorage storage) {
        if (file.exists()) {
            this.copyToTemp(file);
        }
        this.registerProjectToReload(project, file, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProjectToReload(@Nullable Project project, VirtualFile cause, @Nullable StateStorage storage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[RELOAD] Registering project to reload: " + cause, (Throwable)new Exception());
        }
        if (project != null) {
            Map<Project, List<Pair<VirtualFile, StateStorage>>> map = this.myChangedProjectFiles;
            synchronized (map) {
                List<Pair<VirtualFile, StateStorage>> changedProjectFiles = this.myChangedProjectFiles.get(project);
                if (changedProjectFiles == null) {
                    changedProjectFiles = new ArrayList<Pair<VirtualFile, StateStorage>>();
                    this.myChangedProjectFiles.put(project, changedProjectFiles);
                }
                changedProjectFiles.add((Pair<VirtualFile, StateStorage>)new Pair((Object)cause, (Object)storage));
            }
        } else {
            this.myChangedApplicationFiles.add((Pair<VirtualFile, StateStorage>)new Pair((Object)cause, (Object)storage));
        }
        this.myChangedFilesAlarm.cancelAllRequests();
        this.myChangedFilesAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                LOG.debug("[RELOAD] Scheduling reload application & project, myReloadBlockCount = " + ProjectManagerImpl.this.myReloadBlockCount);
                if (ProjectManagerImpl.this.myReloadBlockCount.get() == 0) {
                    ProjectManagerImpl.this.scheduleReloadApplicationAndProject();
                }
            }
        }, 444);
    }

    private void copyToTemp(VirtualFile file) {
        try {
            byte[] bytes = file.contentsToByteArray();
            this.mySavedCopies.put(file, bytes);
            this.mySavedTimestamps.put((Object)file, file.getTimeStamp());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCopy(VirtualFile file) {
        try {
            if (file == null) {
                return;
            }
            if (!file.isWritable()) {
                return;
            }
            byte[] bytes = this.mySavedCopies.get(file);
            if (bytes != null) {
                try {
                    file.setBinaryContent(bytes, -1L, this.mySavedTimestamps.get((Object)file));
                }
                catch (IOException e) {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.write.failed", (Object[])new Object[]{file.getPresentableUrl()}), (String)ProjectBundle.message((String)"project.reload.write.failed.title", (Object[])new Object[0]));
                }
            }
        }
        finally {
            this.mySavedCopies.remove(file);
            this.mySavedTimestamps.remove((Object)file);
        }
    }

    public void reloadProject(@NotNull Project p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "reloadProject"));
        }
        this.reloadProjectImpl(p, true);
    }

    public void reloadProjectImpl(@NotNull Project p, boolean clearCopyToRestore) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "reloadProjectImpl"));
        }
        if (clearCopyToRestore) {
            this.mySavedCopies.clear();
            this.mySavedTimestamps.clear();
        }
        final Project[] project = new Project[]{p};
        ProjectReloadState.getInstance((Project)project[0]).onBeforeAutomaticProjectReload();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<IFile> original;
                LOG.debug("Reloading project.");
                ProjectImpl projectImpl = (ProjectImpl)project[0];
                if (projectImpl.isDisposed()) {
                    return;
                }
                IProjectStore projectStore = projectImpl.getStateStore();
                String location = projectImpl.getPresentableUrl();
                try {
                    IComponentStore.SaveSession saveSession = projectStore.startSave();
                    original = saveSession.getAllStorageFiles(true);
                    saveSession.finishSave();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                if (project[0].isDisposed() || ProjectUtil.closeAndDispose(project[0])) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            for (IFile originalFile : original) {
                                ProjectManagerImpl.this.restoreCopy(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(originalFile));
                            }
                        }
                    });
                    project[0] = null;
                    ProjectUtil.openProject(location, null, true);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeProject"));
        }
        return this.closeProject(project, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeProject(final @NotNull Project project, boolean save, final boolean dispose, boolean checkCanClose) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeProject"));
        }
        if (ProjectManagerImpl.isLight(project)) {
            throw new AssertionError((Object)"must not close light project");
        }
        if (!this.isProjectOpened(project)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (save) {
                FileDocumentManager.getInstance().saveAllDocuments();
                project.save();
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ProjectManagerImpl.this.myOpenProjects;
                    synchronized (list) {
                        ProjectManagerImpl.this.myOpenProjects.remove(project);
                        ProjectManagerImpl.this.cacheOpenProjects();
                        ProjectManagerImpl.this.myTestProjects.remove(project);
                    }
                    ProjectManagerImpl.this.myChangedProjectFiles.remove(project);
                    ProjectManagerImpl.this.fireProjectClosed(project);
                    if (dispose) {
                        Disposer.dispose((Disposable)project);
                    }
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "isLight"));
        }
        return ApplicationManager.getApplication().isUnitTestMode() && project.toString().contains("light_temp_");
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeAndDispose"));
        }
        return this.closeProject(project, true, true, true);
    }

    private void fireProjectClosing(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectClosing(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        this.myListeners.add(listener);
    }

    public void addProjectManagerListener(final @NotNull ProjectManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        this.addProjectManagerListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectManagerImpl.this.removeProjectManagerListener(listener);
            }
        });
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        boolean removed = this.myListeners.remove(listener);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener);
    }

    public void removeProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectOpened(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void fireProjectClosed(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectClosed(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean canClose(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                if (listener.canCloseProject(project)) continue;
                return false;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return true;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectManagerImpl", "ensureCouldCloseIfUnableToSave"));
        }
        ProjectImpl.UnableToSaveProjectNotification[] notifications = (ProjectImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectImpl.UnableToSaveProjectNotification.class, project);
        if (notifications.length == 0) {
            return true;
        }
        String fileNames = StringUtil.join((String[])notifications[0].getFileNames(), (String)"\n");
        String msg = String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName());
        return Messages.showDialog((Project)project, (String)msg, (String)"Unsaved Project", (String)("Read-only files:\n\n" + fileNames), (String[])new String[]{"Yes", "No"}, (int)0, (int)1, (Icon)Messages.getWarningIcon()) == 0;
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        if (this.myDefaultProject != null) {
            this.myDefaultProject.save();
        }
        if (this.myDefaultProjectRootElement == null) {
            this.myDefaultProjectRootElement = new Element(ELEMENT_DEFAULT_PROJECT);
        }
        this.myDefaultProjectRootElement.detach();
        parentNode.addContent(this.myDefaultProjectRootElement);
    }

    public void setDefaultProjectRootElement(Element defaultProjectRootElement) {
        this.myDefaultProjectRootElement = defaultProjectRootElement;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.myDefaultProjectRootElement = parentNode.getChild(ELEMENT_DEFAULT_PROJECT);
        if (this.myDefaultProjectRootElement == null) {
            this.myDefaultProjectRootElement = new Element(ELEMENT_DEFAULT_PROJECT);
        }
        this.myDefaultProjectRootElement.detach();
    }

    public String getExternalFileName() {
        return "project.default";
    }

    @NotNull
    public String getComponentName() {
        if ("ProjectManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getComponentName"));
        }
        return "ProjectManager";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"project.default.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getPresentableName"));
        }
        return string;
    }
}

