/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private volatile boolean myDumb = false;
    private final DumbService.DumbModeListener myPublisher;
    private final Queue<IndexUpdateRunnable> myUpdatesQueue = new Queue(5);
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private static final CacheUpdateRunner NULL_ACTION = new CacheUpdateRunner(null, null);

    public static DumbServiceImpl getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbServiceImpl", "getInstance"));
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project);
    }

    public DumbServiceImpl(Project project, MessageBus bus) {
        this.myProject = project;
        this.myPublisher = (DumbService.DumbModeListener)bus.syncPublisher(DUMB_MODE);
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isDumb() {
        return this.myDumb;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myDumb = true;
            this.myPublisher.enteredDumbMode();
        } else {
            this.updateFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenSmart(Runnable runnable) {
        if (!this.isDumb()) {
            runnable.run();
        } else {
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                this.myRunWhenSmartQueue.addLast((Object)runnable);
            }
        }
    }

    public void queueCacheUpdate(Collection<CacheUpdater> updaters) {
        this.scheduleCacheUpdate(updaters, false);
    }

    public void queueCacheUpdateInDumbMode(Collection<CacheUpdater> updaters) {
        this.scheduleCacheUpdate(updaters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCacheUpdate(Collection<CacheUpdater> updaters, boolean forceDumbMode) {
        Application application;
        CacheUpdateRunner runner;
        block17: {
            runner = new CacheUpdateRunner(this.myProject, new ArrayList<CacheUpdater>(updaters));
            application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                EmptyProgressIndicator i = new EmptyProgressIndicator();
                int size = runner.queryNeededFiles((ProgressIndicator)i);
                try {
                    HeavyProcessLatch.INSTANCE.processStarted();
                    if (size > 0) {
                        runner.processFiles((ProgressIndicator)i, false);
                    }
                    runner.updatingDone();
                }
                finally {
                    HeavyProcessLatch.INSTANCE.processFinished();
                }
                return;
            }
            if (!forceDumbMode && !this.myDumb && application.isReadAccessAllowed()) {
                ProgressIndicator indicator;
                ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (currentIndicator != null) {
                    indicator = currentIndicator;
                    currentIndicator.pushState();
                } else {
                    indicator = new EmptyProgressIndicator();
                }
                try {
                    int size = runner.queryNeededFiles(indicator);
                    if (size + runner.getNumberOfPendingUpdateJobs(indicator) >= 50) break block17;
                    try {
                        HeavyProcessLatch.INSTANCE.processStarted();
                        if (size > 0) {
                            runner.processFiles(indicator, false);
                        }
                        runner.updatingDone();
                    }
                    finally {
                        HeavyProcessLatch.INSTANCE.processFinished();
                    }
                    return;
                }
                finally {
                    if (currentIndicator != null) {
                        currentIndicator.popState();
                    }
                }
            }
        }
        final IndexUpdateRunnable updateRunnable = new IndexUpdateRunnable(runner);
        UIUtil.invokeLaterIfNeeded((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (DumbServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (DumbServiceImpl.this.myDumb) {
                    DumbServiceImpl.this.myUpdatesQueue.addLast((Object)updateRunnable);
                } else {
                    boolean startSuccess = (Boolean)application.runWriteAction((Computable)new Computable<Boolean>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Boolean compute() {
                            DumbServiceImpl.this.myDumb = true;
                            try {
                                DumbServiceImpl.this.myPublisher.enteredDumbMode();
                            }
                            catch (Throwable e) {
                                LOG.error(e);
                            }
                            finally {
                                try {
                                    updateRunnable.run();
                                }
                                catch (Throwable e) {
                                    LOG.error("Failed to start background index update task", e);
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                    if (!startSuccess) {
                        DumbServiceImpl.this.updateFinished();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        this.myDumb = false;
        try {
            if (!this.myProject.isDisposed()) {
                this.myPublisher.exitDumbMode();
                FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
            }
        }
        finally {
            while (!this.myDumb) {
                Runnable runnable;
                Queue<Runnable> queue = this.myRunWhenSmartQueue;
                synchronized (queue) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    public void showDumbModeNotification(final String message) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(DumbServiceImpl.this.myProject);
                if (ideFrame != null) {
                    StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                    statusBar.notifyProgressByBalloon(MessageType.WARNING, message, null, null);
                }
            }
        });
    }

    public void waitForSmartMode() {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            assert (!application.isDispatchThread());
            assert (!application.isReadAccessAllowed());
        }
        if (!this.isDumb()) {
            return;
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.runWhenSmart(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbServiceImpl", "wrapGently"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/DumbServiceImpl", "wrapGently"));
        }
        final DumbUnawareHider wrapper = new DumbUnawareHider(dumbUnawareContent);
        wrapper.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper.setContentVisible(true);
            }
        });
        return wrapper;
    }

    private class IndexUpdateRunnable
    implements Runnable {
        private final CacheUpdateRunner myAction;
        private double myProcessedItems;
        private volatile int myTotalItems;
        private double myCurrentBaseTotal;

        public IndexUpdateRunnable(CacheUpdateRunner action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbServiceImpl$IndexUpdateRunnable", "<init>"));
            }
            this.myAction = action;
            this.myTotalItems = 0;
            this.myCurrentBaseTotal = 0.0;
        }

        @Override
        public void run() {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(DumbServiceImpl.this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbServiceImpl$IndexUpdateRunnable$1", "run"));
                    }
                    if (indicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)indicator).addStateDelegate(new ProgressIndicatorBase(){
                            double lastFraction;

                            @Override
                            public void setFraction(final double fraction) {
                                if (fraction - this.lastFraction < 0.01) {
                                    return;
                                }
                                this.lastFraction = fraction;
                                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        AppIcon.getInstance().setProgress(myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true);
                                    }
                                });
                            }

                            @Override
                            public void finish(@NotNull TaskInfo task) {
                                if (task == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbServiceImpl$IndexUpdateRunnable$1$1", "finish"));
                                }
                                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        AppIcon appIcon = AppIcon.getInstance();
                                        if (appIcon.hideProgress(myProject, "indexUpdate")) {
                                            appIcon.requestAttention(myProject, false);
                                            appIcon.setOkBadge(myProject, true);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    DelegatingProgressIndicator proxy = new DelegatingProgressIndicator(indicator){

                        public void setFraction(double fraction) {
                            super.setFraction((IndexUpdateRunnable.this.myProcessedItems + fraction * IndexUpdateRunnable.this.myCurrentBaseTotal) / (double)IndexUpdateRunnable.this.myTotalItems);
                        }
                    };
                    ShutDownTracker shutdownTracker = ShutDownTracker.getInstance();
                    Thread self = Thread.currentThread();
                    try {
                        HeavyProcessLatch.INSTANCE.processStarted();
                        shutdownTracker.registerStopperThread(self);
                        this.runAction((ProgressIndicator)proxy, IndexUpdateRunnable.this.myAction);
                    }
                    catch (RuntimeException e) {
                        LOG.error((Throwable)e);
                        throw e;
                    }
                    finally {
                        shutdownTracker.unregisterStopperThread(self);
                        HeavyProcessLatch.INSTANCE.processFinished();
                    }
                }

                private void runAction(ProgressIndicator indicator, CacheUpdateRunner updateRunner) {
                    while (updateRunner != null) {
                        try {
                            indicator.checkCanceled();
                            indicator.setIndeterminate(true);
                            indicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                            int count = updateRunner.queryNeededFiles(indicator);
                            IndexUpdateRunnable.this.myCurrentBaseTotal = count;
                            IndexUpdateRunnable.this.myTotalItems += count;
                            indicator.setIndeterminate(false);
                            indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
                            if (count > 0) {
                                updateRunner.processFiles(indicator, true);
                            }
                            updateRunner.updatingDone();
                            IndexUpdateRunnable.this.myProcessedItems += count;
                        }
                        catch (ProcessCanceledException ignored) {
                        }
                        catch (Throwable unexpected) {
                            LOG.error(unexpected);
                        }
                        updateRunner = this.getNextUpdateRunner();
                    }
                }

                @Nullable
                private CacheUpdateRunner getNextUpdateRunner() {
                    final LinkedBlockingQueue actionQueue = new LinkedBlockingQueue();
                    UIUtil.invokeLaterIfNeeded((Runnable)new DumbAwareRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            IndexUpdateRunnable nextRunnable = this.getNextUpdateFromQueue();
                            try {
                                actionQueue.offer(nextRunnable == null ? NULL_ACTION : nextRunnable.myAction);
                            }
                            finally {
                                if (nextRunnable == null) {
                                    DumbServiceImpl.this.updateFinished();
                                }
                            }
                        }
                    });
                    while (!this.myProject.isDisposed()) {
                        try {
                            CacheUpdateRunner ref = (CacheUpdateRunner)actionQueue.poll(500L, TimeUnit.MILLISECONDS);
                            if (ref == null) continue;
                            return ref == NULL_ACTION ? null : ref;
                        }
                        catch (InterruptedException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    return null;
                }

                @Nullable
                private IndexUpdateRunnable getNextUpdateFromQueue() {
                    try {
                        return DumbServiceImpl.this.myUpdatesQueue.isEmpty() ? null : (IndexUpdateRunnable)DumbServiceImpl.this.myUpdatesQueue.pullFirst();
                    }
                    catch (Throwable e) {
                        LOG.info(e);
                        return null;
                    }
                }
            });
        }
    }
}

