/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooManyUsagesStatus {
    private static final Key<TooManyUsagesStatus> KEY = Key.create((String)"TooManyUsagesStatus");
    private static final Null NULL = new Null();
    private final AtomicReference<Status> tooManyUsagesStatus = new AtomicReference<Status>(Status.FEW_USAGES);
    private final CountDownLatch waitWhileUserClick = new CountDownLatch(1);

    @NotNull
    public static TooManyUsagesStatus getFrom(@Nullable ProgressIndicator indicator) {
        TooManyUsagesStatus data = null;
        if (indicator instanceof UserDataHolder) {
            data = (TooManyUsagesStatus)((UserDataHolder)indicator).getUserData(KEY);
        }
        if (data == null) {
            data = NULL;
        }
        Null nullVal = data;
        if (nullVal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/TooManyUsagesStatus", "getFrom"));
        }
        return nullVal;
    }

    public static TooManyUsagesStatus createFor(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/TooManyUsagesStatus", "createFor"));
        }
        TooManyUsagesStatus data = null;
        if (indicator instanceof UserDataHolder) {
            data = new TooManyUsagesStatus();
            ((UserDataHolder)indicator).putUserData(KEY, (Object)data);
        }
        return data;
    }

    public boolean switchTooManyUsagesStatus() {
        return this.tooManyUsagesStatus.get() == Status.FEW_USAGES && this.tooManyUsagesStatus.compareAndSet(Status.FEW_USAGES, Status.WARNING_DIALOG_SHOWN);
    }

    public void userResponded() {
        this.waitWhileUserClick.countDown();
        this.tooManyUsagesStatus.set(Status.USER_RESPONDED);
    }

    public void pauseProcessingIfTooManyUsages() {
        if (this.tooManyUsagesStatus.get() == Status.WARNING_DIALOG_SHOWN) {
            try {
                this.waitWhileUserClick.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class Null
    extends TooManyUsagesStatus {
        private Null() {
        }

        @Override
        public boolean switchTooManyUsagesStatus() {
            return false;
        }

        @Override
        public void userResponded() {
        }

        @Override
        public void pauseProcessingIfTooManyUsages() {
        }
    }

    public static enum Status {
        FEW_USAGES,
        WARNING_DIALOG_SHOWN,
        USER_RESPONDED;

    }
}

