/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.util.ProgressIndicatorListener;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import java.util.LinkedList;
import javax.swing.JComponent;

public class ProgressWindowWithNotification
extends ProgressWindow {
    private final LinkedList<ProgressIndicatorListener> myListeners = new LinkedList();

    public ProgressWindowWithNotification(boolean shouldShowCancel, Project project) {
        super(shouldShowCancel, project);
    }

    public ProgressWindowWithNotification(boolean shouldShowCancel, boolean shouldShowBackground, Project project) {
        super(shouldShowCancel, shouldShowBackground, project);
    }

    public ProgressWindowWithNotification(boolean shouldShowCancel, boolean shouldShowBackground, Project project, String cancelText) {
        super(shouldShowCancel, shouldShowBackground, project, cancelText);
    }

    public ProgressWindowWithNotification(boolean shouldShowCancel, boolean shouldShowBackground, Project project, JComponent parentComponent, String cancelText) {
        super(shouldShowCancel, shouldShowBackground, project, parentComponent, cancelText);
    }

    @Override
    public void cancel() {
        super.cancel();
        for (ProgressIndicatorListener progressIndicatorListener : this.myListeners) {
            progressIndicatorListener.cancelled();
        }
    }

    @Override
    public synchronized void stop() {
        for (ProgressIndicatorListener progressIndicatorListener : this.myListeners) {
            progressIndicatorListener.stopped();
        }
        super.stop();
    }

    public void addListener(ProgressIndicatorListener listener) {
        this.myListeners.addFirst(listener);
    }

    public void removeListener(ProgressIndicatorListener listener) {
        this.myListeners.remove(listener);
    }
}

