/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiLock;
import com.intellij.ui.SystemNotifications;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends ProgressManager
implements Disposable {
    private final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static volatile int ourLockedCheckCounter = 0;
    private static final boolean DISABLED = "disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private final ScheduledFuture<?> myCheckCancelledFuture = !DISABLED ? JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

        @Override
        public void run() {
            ourNeedToCheckCancel = true;
            ProgressIndicatorProvider.ourNeedToCheckCancel = true;
        }
    }, 0L, 10L, TimeUnit.MILLISECONDS) : null;

    public ProgressManagerImpl(Application application) {
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null) {
            try {
                progress.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                if (DISABLED) {
                    return;
                }
                if (Thread.holdsLock(PsiLock.LOCK)) {
                    if (++ourLockedCheckCounter > 10) {
                        ourLockedCheckCounter = 0;
                        ourNeedToCheckCancel = true;
                        ProgressIndicatorProvider.ourNeedToCheckCancel = true;
                    }
                }
                ourLockedCheckCounter = 0;
                throw e;
            }
        }
    }

    public static void canceled() {
        ourNeedToCheckCancel = true;
        ProgressIndicatorProvider.ourNeedToCheckCancel = true;
    }

    public final NonCancelableSection startNonCancelableSection() {
        NonCancelableIndicator nonCancelor = new NonCancelableIndicator((ProgressIndicator)myThreadIndicator.get());
        myThreadIndicator.set(nonCancelor);
        return nonCancelor;
    }

    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "executeNonCancelableSection"));
        }
        this.executeProcessUnderProgress(runnable, (ProgressIndicator)new NonCancelableIndicator(this.getProgressIndicator()));
    }

    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginal()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    public boolean hasUnsafeProgressIndicator() {
        return this.myCurrentUnsafeProgressCount.get() > 0;
    }

    public boolean hasModalProgressIndicator() {
        return this.myCurrentModalProgressCount.get() > 0;
    }

    public void runProcess(final @NotNull Runnable process, final ProgressIndicator progress) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcess"));
        }
        this.executeProcessUnderProgress(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                    process.run();
                    ProgressManagerImpl.maybeSleep();
                }
                finally {
                    if (progress != null && progress.isRunning()) {
                        progress.stop();
                        if (progress instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)progress).processFinish();
                        }
                    }
                }
            }
        }, progress);
    }

    public <T> T runProcess(final @NotNull Computable<T> process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcess"));
        }
        final Ref ref = new Ref();
        this.runProcess(new Runnable(){

            @Override
            public void run() {
                ref.set(process.compute());
            }
        }, progress);
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        boolean modal;
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "executeProcessUnderProgress"));
        }
        boolean bl = modal = progress != null && progress.isModal();
        if (modal) {
            this.myCurrentModalProgressCount.incrementAndGet();
        }
        if (progress == null || progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        try {
            super.executeProcessUnderProgress(process, progress);
        }
        finally {
            if (progress == null || progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
            if (modal) {
                this.myCurrentModalProgressCount.decrementAndGet();
            }
        }
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        final Ref result = new Ref();
        final Ref exception = new Ref();
        ProgressManagerImpl.runProcessWithProgressSynchronously((Task)new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl$4", "run"));
                }
                try {
                    Object compute = process.compute();
                    result.set(compute);
                }
                catch (Throwable t) {
                    exception.set((Object)t);
                }
            }
        }, null);
        if (!exception.isNull()) {
            Throwable t = (Throwable)exception.get();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result.get();
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        Task.Modal task = new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl$5", "run"));
                }
                process.run();
            }
        };
        return ProgressManagerImpl.runProcessWithProgressSynchronously((Task)task, parentComponent);
    }

    private static boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        long start = System.currentTimeMillis();
        boolean result = ((ApplicationEx)ApplicationManager.getApplication()).runProcessWithProgressSynchronously(new TaskContainer(task){

            @Override
            public void run() {
                new TaskRunnable(task, ProgressManager.getInstance().getProgressIndicator()).run();
            }
        }, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        if (result) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start;
            if (notificationInfo != null && time > 5000L && !(frame = WindowManager.getInstance().getFrame(task.getProject())).hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
            task.onSuccess();
        } else {
            task.onCancel();
        }
        return result;
    }

    private static void systemNotify(Task.NotificationInfo notificationInfo) {
        SystemNotifications.getInstance().notify(notificationInfo.getNotificationName(), notificationInfo.getNotificationTitle(), notificationInfo.getNotificationText());
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull String progressTitle, @NotNull Runnable process, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @Nls @NotNull String progressTitle, final @NotNull Runnable process, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        ProgressManagerImpl.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl$7", "run"));
                }
                process.run();
            }

            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }
        });
    }

    private static void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        ProgressManagerImpl.runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator, null);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        ProgressManagerImpl.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @NotNull
    public static Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final TaskRunnable process = new TaskRunnable((Task)task, progressIndicator, continuation);
        TaskContainer action = new TaskContainer((Task)task){

            @Override
            public void run() {
                boolean canceled = false;
                long start = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    canceled = true;
                }
                long end = System.currentTimeMillis();
                long time = end - start;
                if (canceled || progressIndicator.isCanceled()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onCancel();
                        }
                    }, ModalityState.NON_MODAL);
                } else {
                    Window window;
                    Task.NotificationInfo notificationInfo = task.notifyFinished();
                    if (notificationInfo != null && time > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onSuccess();
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        };
        Future future = ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    public void run(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "run"));
        }
        if (task.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ProgressManagerImpl.runProcessWithProgressSynchronously(task, null);
            } else {
                new TaskRunnable(task, (ProgressIndicator)new EmptyProgressIndicator()).run();
            }
        } else if (task.isModal()) {
            ProgressManagerImpl.runProcessWithProgressSynchronously((Task)task.asModal(), null);
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                ProgressManagerImpl.runProcessWithProgressSynchronously(task, null);
            } else {
                ProgressManagerImpl.runProcessWithProgressAsynchronously(backgroundable);
            }
        }
    }

    public void dispose() {
        this.stopCheckCanceled();
    }

    private void stopCheckCanceled() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(false);
        }
    }

    public static String isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "isCanceledThread"));
        }
        try {
            Field th = Thread.class.getDeclaredField("threadLocals");
            th.setAccessible(true);
            Object tLocalMap = th.get(thread);
            if (tLocalMap == null) {
                return null;
            }
            Method getEntry = tLocalMap.getClass().getDeclaredMethod("getEntry", ThreadLocal.class);
            getEntry.setAccessible(true);
            Object entry = getEntry.invoke(tLocalMap, myThreadIndicator);
            if (entry == null) {
                return null;
            }
            Field value = entry.getClass().getDeclaredField("value");
            value.setAccessible(true);
            ProgressIndicator indicator = (ProgressIndicator)value.get(entry);
            if (indicator == null) {
                return null;
            }
            return String.valueOf(indicator.isCanceled());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void maybeSleep() {
        int debugProgressTime = Registry.intValue((String)"ide.debug.minProgressTime");
        if (debugProgressTime > 0) {
            try {
                Thread.sleep(debugProgressTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        private TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskRunnable", "<init>"));
            }
            this(task, indicator, (Runnable)null);
        }

        private TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskRunnable", "<init>"));
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish((TaskInfo)this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }
    }

    private static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskContainer", "<init>"));
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskContainer", "getTask"));
            }
            return task;
        }
    }

    private static class NonCancelableIndicator
    extends EmptyProgressIndicator
    implements NonCancelableSection {
        private final ProgressIndicator myOld;

        private NonCancelableIndicator(ProgressIndicator old) {
            this.myOld = old;
        }

        public void done() {
            ProgressIndicator currentIndicator = (ProgressIndicator)myThreadIndicator.get();
            if (currentIndicator != this) {
                throw new AssertionError((Object)"Trying do .done() NonCancelableSection, which is already done");
            }
            myThreadIndicator.set(this.myOld);
        }

        public void checkCanceled() {
        }
    }
}

