/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.ui.speedSearch.ElementFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsEditorContext {
    ElementFilter.Active myFilter;
    CopyOnWriteArraySet<OptionsEditorColleague> myColleagues = new CopyOnWriteArraySet();
    Configurable myCurrentConfigurable;
    Set<Configurable> myModified = new CopyOnWriteArraySet<Configurable>();
    Map<Configurable, ConfigurationException> myErrors = new HashMap<Configurable, ConfigurationException>();
    private boolean myHoldingFilter;
    private final Map<Configurable, Configurable> myConfigurableToParentMap = new HashMap<Configurable, Configurable>();
    private final MultiValuesMap<Configurable, Configurable> myParentToChildrenMap = new MultiValuesMap();

    public OptionsEditorContext(ElementFilter.Active filter) {
        this.myFilter = filter;
    }

    ActionCallback fireSelected(final @Nullable Configurable configurable, @NotNull OptionsEditorColleague requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/options/newEditor/OptionsEditorContext", "fireSelected"));
        }
        if (this.myCurrentConfigurable == configurable) {
            return new ActionCallback.Rejected();
        }
        final Configurable old = this.myCurrentConfigurable;
        this.myCurrentConfigurable = configurable;
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onSelected(configurable, old);
            }
        }, requestor);
    }

    ActionCallback fireModifiedAdded(final @NotNull Configurable configurable, @Nullable OptionsEditorColleague requestor) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/newEditor/OptionsEditorContext", "fireModifiedAdded"));
        }
        if (this.myModified.contains(configurable)) {
            return new ActionCallback.Rejected();
        }
        this.myModified.add(configurable);
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onModifiedAdded(configurable);
            }
        }, requestor);
    }

    ActionCallback fireModifiedRemoved(final @NotNull Configurable configurable, @Nullable OptionsEditorColleague requestor) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/newEditor/OptionsEditorContext", "fireModifiedRemoved"));
        }
        if (!this.myModified.contains(configurable)) {
            return new ActionCallback.Rejected();
        }
        this.myModified.remove(configurable);
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onModifiedRemoved(configurable);
            }
        }, requestor);
    }

    ActionCallback fireErrorsChanged(Map<Configurable, ConfigurationException> errors, OptionsEditorColleague requestor) {
        if (((Object)this.myErrors).equals(errors)) {
            return new ActionCallback.Rejected();
        }
        this.myErrors = errors != null ? errors : new HashMap();
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onErrorsChanged();
            }
        }, requestor);
    }

    ActionCallback notify(ColleagueAction action, OptionsEditorColleague requestor) {
        ActionCallback.Chunk chunk = new ActionCallback.Chunk();
        for (OptionsEditorColleague each : this.myColleagues) {
            if (each == requestor) continue;
            chunk.add(action.process(each));
        }
        return chunk.getWhenProcessed();
    }

    public void fireReset(Configurable configurable) {
        if (this.myModified.contains(configurable)) {
            this.fireModifiedRemoved(configurable, null);
        }
        if (this.myErrors.containsKey(configurable)) {
            HashMap<Configurable, ConfigurationException> newErrors = new HashMap<Configurable, ConfigurationException>();
            newErrors.remove(configurable);
            this.fireErrorsChanged(newErrors, null);
        }
    }

    public boolean isModified(Configurable configurable) {
        return this.myModified.contains(configurable);
    }

    public void setHoldingFilter(boolean holding) {
        this.myHoldingFilter = holding;
    }

    public boolean isHoldingFilter() {
        return this.myHoldingFilter;
    }

    public Configurable getParentConfigurable(Configurable configurable) {
        return this.myConfigurableToParentMap.get(configurable);
    }

    public void registerKid(Configurable parent, Configurable kid) {
        this.myConfigurableToParentMap.put(kid, parent);
        this.myParentToChildrenMap.put((Object)parent, (Object)kid);
    }

    public Collection<Configurable> getChildren(Configurable parent) {
        Collection result = this.myParentToChildrenMap.get((Object)parent);
        return result == null ? Collections.emptySet() : result;
    }

    @NotNull
    ElementFilter<Configurable> getFilter() {
        ElementFilter.Active active = this.myFilter;
        if (active == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/OptionsEditorContext", "getFilter"));
        }
        return active;
    }

    public Configurable getCurrentConfigurable() {
        return this.myCurrentConfigurable;
    }

    public Set<Configurable> getModified() {
        return this.myModified;
    }

    public Map<Configurable, ConfigurationException> getErrors() {
        return this.myErrors;
    }

    public void addColleague(OptionsEditorColleague colleague) {
        this.myColleagues.add(colleague);
    }

    static interface ColleagueAction {
        public ActionCallback process(OptionsEditorColleague var1);
    }
}

