/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurablesGroupBase
implements ConfigurableGroup {
    private Configurable[] myChildren;
    private ComponentManager myComponentManager;
    private final ExtensionPointName<ConfigurableEP<Configurable>> myConfigurablesExtensionPoint;
    private final boolean myLoadComponents;

    protected ConfigurablesGroupBase(ComponentManager componentManager, ExtensionPointName<ConfigurableEP<Configurable>> configurablesExtensionPoint, boolean loadComponents) {
        this.myComponentManager = componentManager;
        this.myConfigurablesExtensionPoint = configurablesExtensionPoint;
        this.myLoadComponents = loadComponents;
    }

    public Configurable[] getConfigurables() {
        if (this.myChildren == null) {
            ConfigurableEP[] extensions = (ConfigurableEP[])this.myComponentManager.getExtensions(this.myConfigurablesExtensionPoint);
            Configurable[] components = this.myLoadComponents ? (Configurable[])this.myComponentManager.getComponents(Configurable.class) : new Configurable[]{};
            List<Configurable> result = ConfigurableExtensionPointUtil.buildConfigurablesList(extensions, components, this.getConfigurableFilter());
            this.myChildren = result.toArray(new Configurable[result.size()]);
        }
        return this.myChildren;
    }

    @Nullable
    protected abstract ConfigurableFilter getConfigurableFilter();
}

