/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ColorSettingsPagesImpl
extends ColorSettingsPages {
    private final List<ColorSettingsPage> myPages = new ArrayList<ColorSettingsPage>();
    private boolean myExtensionsLoaded = false;
    private final Map<TextAttributesKey, Pair<ColorSettingsPage, AttributesDescriptor>> myKeyToDescriptorMap = new HashMap<TextAttributesKey, Pair<ColorSettingsPage, AttributesDescriptor>>();

    public void registerPage(ColorSettingsPage page) {
        this.myPages.add(page);
    }

    public ColorSettingsPage[] getRegisteredPages() {
        if (!this.myExtensionsLoaded) {
            this.myExtensionsLoaded = true;
            Collections.addAll(this.myPages, Extensions.getExtensions((ExtensionPointName)ColorSettingsPage.EP_NAME));
        }
        return this.myPages.toArray(new ColorSettingsPage[this.myPages.size()]);
    }

    @Nullable
    public Pair<ColorSettingsPage, AttributesDescriptor> getAttributeDescriptor(TextAttributesKey key) {
        if (this.myKeyToDescriptorMap.containsKey(key)) {
            return this.myKeyToDescriptorMap.get(key);
        }
        for (ColorSettingsPage page : this.getRegisteredPages()) {
            for (AttributesDescriptor descriptor : page.getAttributeDescriptors()) {
                if (descriptor.getKey() != key) continue;
                Pair result = new Pair((Object)page, (Object)descriptor);
                this.myKeyToDescriptorMap.put(key, (Pair<ColorSettingsPage, AttributesDescriptor>)result);
                return result;
            }
        }
        this.myKeyToDescriptorMap.put(key, null);
        return null;
    }
}

