/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.UniqueFileNamesProvider;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesManager<T extends Scheme, E extends ExternalizableScheme>
implements SchemesManager<T, E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.AbstractSchemesManager");
    protected final List<T> mySchemes = new ArrayList<T>();
    private volatile T myCurrentScheme;
    private String myCurrentSchemeName;

    public void addNewScheme(@NotNull T scheme, boolean replaceExisting) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/AbstractSchemesManager", "addNewScheme"));
        }
        int toReplace = -1;
        boolean newSchemeIsShared = this.isShared((Scheme)scheme);
        for (int i = 0; i < this.mySchemes.size(); ++i) {
            Scheme t = (Scheme)this.mySchemes.get(i);
            if (!Comparing.equal((String)scheme.getName(), (String)t.getName()) || newSchemeIsShared != this.isShared(t)) continue;
            toReplace = i;
            break;
        }
        if (toReplace == -1) {
            this.mySchemes.add(scheme);
        } else if (replaceExisting || !this.isExternalizable(scheme)) {
            this.mySchemes.set(toReplace, scheme);
        } else {
            this.renameScheme((ExternalizableScheme)scheme, this.generateUniqueName(scheme));
            this.mySchemes.add(scheme);
        }
        this.onSchemeAdded(scheme);
        this.checkCurrentScheme((Scheme)scheme);
    }

    protected void checkCurrentScheme(Scheme scheme) {
        if (this.myCurrentScheme == null && this.myCurrentSchemeName != null && this.myCurrentSchemeName.equals(scheme.getName())) {
            this.myCurrentScheme = scheme;
        }
    }

    private String generateUniqueName(T scheme) {
        return UniqueNameGenerator.generateUniqueName((String)UniqueFileNamesProvider.convertName((String)scheme.getName()), this.collectExistingNames(this.mySchemes));
    }

    private Collection<String> collectExistingNames(Collection<T> schemes) {
        HashSet result = new HashSet();
        for (Scheme scheme : schemes) {
            result.add((Object)scheme.getName());
        }
        return result;
    }

    public void clearAllSchemes() {
        for (Scheme t : this.getAllSchemes()) {
            this.removeScheme(t);
        }
    }

    @NotNull
    public List<T> getAllSchemes() {
        List<T> list = Collections.unmodifiableList(new ArrayList<T>(this.mySchemes));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "getAllSchemes"));
        }
        return list;
    }

    @Nullable
    public T findSchemeByName(String schemeName) {
        for (Scheme scheme : this.mySchemes) {
            if (!Comparing.equal((String)scheme.getName(), (String)schemeName)) continue;
            return (T)scheme;
        }
        return null;
    }

    public abstract void save() throws WriteExternalException;

    public void setCurrentSchemeName(String schemeName) {
        this.myCurrentSchemeName = schemeName;
        this.myCurrentScheme = schemeName == null ? null : this.findSchemeByName(schemeName);
    }

    @Nullable
    public T getCurrentScheme() {
        T currentScheme = this.myCurrentScheme;
        if (currentScheme == null) {
            return null;
        }
        return this.findSchemeByName(currentScheme.getName());
    }

    public void removeScheme(T scheme) {
        String schemeName = scheme.getName();
        Scheme toDelete = this.findSchemeToDelete(schemeName);
        this.mySchemes.remove(toDelete);
        if (this.myCurrentScheme == toDelete) {
            this.myCurrentScheme = null;
        }
        this.onSchemeDeleted(toDelete);
    }

    protected abstract void onSchemeDeleted(Scheme var1);

    private Scheme findSchemeToDelete(String schemeName) {
        for (Scheme scheme : this.mySchemes) {
            if (!Comparing.equal((String)schemeName, (String)scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        Collection<String> collection = this.getAllSchemeNames(this.mySchemes);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "getAllSchemeNames"));
        }
        return collection;
    }

    public Collection<String> getAllSchemeNames(Collection<T> schemes) {
        THashSet names = new THashSet();
        for (Scheme scheme : schemes) {
            names.add(scheme.getName());
        }
        return names;
    }

    protected abstract void onSchemeAdded(T var1);

    protected void renameScheme(E scheme, String newName) {
        if (!Comparing.equal((String)newName, (String)scheme.getName())) {
            scheme.setName(newName);
            LOG.assertTrue(Comparing.equal((String)newName, (String)scheme.getName()));
        }
    }

    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes() {
        Collection collection = this.loadSharedSchemes(this.getAllSchemes());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "loadSharedSchemes"));
        }
        return collection;
    }

    protected boolean isExternalizable(T scheme) {
        return scheme instanceof ExternalizableScheme;
    }
}

