/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryScopeBase
extends GlobalSearchScope {
    private final LinkedHashSet<VirtualFile> myEntries;
    protected final ProjectFileIndex myIndex;

    public LibraryScopeBase(Project project, VirtualFile[] classes, VirtualFile[] sources) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myEntries = new LinkedHashSet(classes.length + sources.length);
        Collections.addAll(this.myEntries, classes);
        Collections.addAll(this.myEntries, sources);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/scopes/LibraryScopeBase", "contains"));
        }
        return this.myEntries.contains(this.getFileRoot(file));
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/scopes/LibraryScopeBase", "getFileRoot"));
        }
        if (this.myIndex.isInLibraryClasses(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        if (this.myIndex.isInContent(file)) {
            return this.myIndex.getSourceRootForFile(file);
        }
        return null;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/scopes/LibraryScopeBase", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/module/impl/scopes/LibraryScopeBase", "compare"));
        }
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (Comparing.equal((Object)r1, (Object)root)) {
                return 1;
            }
            if (!Comparing.equal((Object)r2, (Object)root)) continue;
            return -1;
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/scopes/LibraryScopeBase", "isSearchInModuleContent"));
        }
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }
}

