/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;

@State(name="ProjectModuleManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/modules.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class ModuleManagerComponent
extends ModuleManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerComponent");
    private final ProgressManager myProgressManager;
    private final MessageBusConnection myConnection;

    public ModuleManagerComponent(Project project, ProgressManager progressManager, MessageBus bus) {
        super(project, bus);
        this.myConnection = bus.connect((Disposable)project);
        this.myProgressManager = progressManager;
        this.myConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                ModuleManagerComponent.this.cleanCachedStuff();
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        this.myConnection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

            public void projectComponentsInitialized(Project project) {
                long t = System.currentTimeMillis();
                ModuleManagerComponent.this.loadModules(ModuleManagerComponent.this.myModuleModel);
                t = System.currentTimeMillis() - t;
                LOG.info(ModuleManagerComponent.this.myModuleModel.getModules().length + " module(s) loaded in " + t + " ms");
            }
        });
    }

    @Override
    protected void showUnknownModuleTypeNotification(List<Module> modulesWithUnknownTypes) {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
            String message;
            if (modulesWithUnknownTypes.size() == 1) {
                message = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{modulesWithUnknownTypes.get(0).getName(), ModuleType.get((Module)modulesWithUnknownTypes.get(0)).getId()});
            } else {
                StringBuilder modulesBuilder = new StringBuilder();
                for (Module module : modulesWithUnknownTypes) {
                    modulesBuilder.append("<br>\"");
                    modulesBuilder.append(module.getName()).append("\" (type '").append(ModuleType.get((Module)module).getId()).append("')");
                }
                modulesBuilder.append("<br>");
                message = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
            }
            Notifications.Bus.notify((Notification)new Notification("Module Manager", ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]), message, NotificationType.WARNING), (Project)this.myProject);
        }
    }

    @Override
    protected ModuleEx createModule(String filePath) {
        return new ModuleImpl(filePath, this.myProject);
    }

    @Override
    protected ModuleEx createAndLoadModule(String filePath) throws IOException {
        ModuleImpl module = new ModuleImpl(filePath, this.myProject);
        module.getStateStore().load();
        return module;
    }

    @Override
    protected boolean isUnknownModuleType(Module module) {
        return ModuleType.get((Module)module) instanceof UnknownModuleType;
    }

    @Override
    protected void fireModulesAdded() {
        Runnable runnableWithProgress = new Runnable(){

            @Override
            public void run() {
                for (final Module module : ModuleManagerComponent.this.myModuleModel.myPathToModule.values()) {
                    Application app = ApplicationManager.getApplication();
                    Runnable swingRunnable = new Runnable(){

                        @Override
                        public void run() {
                            ModuleManagerComponent.this.fireModuleAddedInWriteAction(module);
                        }
                    };
                    if (app.isDispatchThread() || app.isHeadlessEnvironment()) {
                        swingRunnable.run();
                        continue;
                    }
                    ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                    app.invokeAndWait(swingRunnable, pi.getModalityState());
                }
            }
        };
        ProgressIndicator progressIndicator = this.myProgressManager.getProgressIndicator();
        if (progressIndicator == null) {
            this.myProgressManager.runProcessWithProgressSynchronously(runnableWithProgress, "Initializing modules...", false, this.myProject);
        } else {
            runnableWithProgress.run();
        }
    }

    @Override
    protected void deliverPendingEvents() {
        this.myConnection.deliverImmediately();
    }
}

