/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;

public class ModuleNavigatable
implements Navigatable {
    private final Module module;

    public ModuleNavigatable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/ModuleNavigatable", "<init>"));
        }
        this.module = module;
    }

    public void navigate(boolean requestFocus) {
        ProjectSettingsService.getInstance(this.module.getProject()).openContentEntriesSettings(this.module);
    }

    public boolean canNavigate() {
        return !this.module.isDisposed();
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

