/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TIntHashSet;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class IgnoredFileCache {
    private final BitSet myCheckedIds = new BitSet();
    private final TIntHashSet myIgnoredIds = new TIntHashSet();
    private final IgnoredPatternSet myIgnoredPatterns;
    private int myVfsEventNesting = 0;

    IgnoredFileCache(IgnoredPatternSet ignoredPatterns) {
        this.myIgnoredPatterns = ignoredPatterns;
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "before"));
                }
                IgnoredFileCache.this.myVfsEventNesting++;
                this.clearCacheForChangedFiles(events);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "after"));
                }
                this.clearCacheForChangedFiles(events);
                IgnoredFileCache.this.myVfsEventNesting--;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void clearCacheForChangedFiles(List<? extends VFileEvent> events) {
                IntArrayList ids = this.collectChangedIds(events);
                BitSet bitSet = IgnoredFileCache.this.myCheckedIds;
                synchronized (bitSet) {
                    for (int i : ids.toArray()) {
                        IgnoredFileCache.this.myCheckedIds.clear(i);
                    }
                }
            }

            private IntArrayList collectChangedIds(List<? extends VFileEvent> events) {
                IntArrayList ids = new IntArrayList();
                for (VFileEvent vFileEvent : events) {
                    int id;
                    VirtualFile file = vFileEvent.getFile();
                    if (!(file instanceof NewVirtualFile) || !(vFileEvent instanceof VFilePropertyChangeEvent) || (id = ((NewVirtualFile)file).getId()) < 0) continue;
                    ids.add(id);
                }
                return ids;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        BitSet bitSet = this.myCheckedIds;
        synchronized (bitSet) {
            this.myCheckedIds.clear();
            this.myIgnoredIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFileIgnored(VirtualFile file) {
        if (this.myVfsEventNesting != 0 || !(file instanceof NewVirtualFile)) {
            return this.isFileIgnoredNoCache(file);
        }
        int id = ((NewVirtualFile)file).getId();
        if (id < 0) {
            return this.isFileIgnoredNoCache(file);
        }
        BitSet bitSet = this.myCheckedIds;
        synchronized (bitSet) {
            if (this.myCheckedIds.get(id)) {
                return this.myIgnoredIds.contains(id);
            }
        }
        boolean result = this.isFileIgnoredNoCache(file);
        BitSet bitSet2 = this.myCheckedIds;
        synchronized (bitSet2) {
            this.myCheckedIds.set(id);
            if (result) {
                this.myIgnoredIds.add(id);
            } else {
                this.myIgnoredIds.remove(id);
            }
        }
        return result;
    }

    private boolean isFileIgnoredNoCache(VirtualFile file) {
        return this.myIgnoredPatterns.isIgnored(file.getName());
    }
}

