/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.ReadFileType;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.CustomFileTypeFactory;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.fileTypes.impl.ImportedFileType;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeManagerImpl
extends FileTypeManagerEx
implements NamedJDOMExternalizable,
ExportableApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl");
    private static final int VERSION = 11;
    private static final Key<FileType> FILE_TYPE_KEY = Key.create((String)"FILE_TYPE_KEY");
    private static final Key<FileType> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private final Set<FileType> myDefaultTypes = new THashSet();
    private final List<FileTypeIdentifiableByVirtualFile> mySpecialFileTypes = new ArrayList<FileTypeIdentifiableByVirtualFile>();
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final Map<FileNameMatcher, Trinity<String, String, Boolean>> myUnresolvedRemovedMappings = new THashMap();
    private final Map<FileNameMatcher, Pair<FileType, Boolean>> myRemovedMappings = new THashMap();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_FILETYPES = "filetypes";
    @NonNls
    private static final String ELEMENT_IGNOREFILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ATTRIBUTE_EXTENSIONS = "extensions";
    @NonNls
    private static final String ATTRIBUTE_BINARY = "binary";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_EXTENSION = "default_extension";
    private final MessageBus myMessageBus;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    private final SchemesManager<FileType, AbstractFileType> mySchemesManager;
    @NonNls
    private static final String FILE_SPEC = "$ROOT_CONFIG$/filetypes";
    private static final AtomicInteger DETECTED_COUNT = new AtomicInteger();
    private static final int DETECT_BUFFER_SIZE = 8192;
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    private void initStandardFileTypes() {
        FileTypeConsumer consumer = new FileTypeConsumer(){

            public void consume(@NotNull FileType fileType) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "consume"));
                }
                this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
            }

            public void consume(@NotNull FileType fileType, String extensions) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "consume"));
                }
                this.register(fileType, FileTypeManagerImpl.parse(extensions));
            }

            public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "consume"));
                }
                this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
            }

            public FileType getStandardFileTypeByName(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getStandardFileTypeByName"));
                }
                StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name);
                return type != null ? type.fileType : null;
            }

            private void register(FileType fileType, List<FileNameMatcher> fileNameMatchers) {
                StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName());
                if (type != null) {
                    for (FileNameMatcher matcher : fileNameMatchers) {
                        type.matchers.add(matcher);
                    }
                } else {
                    FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                }
            }
        };
        for (FileTypeFactory factory : (FileTypeFactory[])Extensions.getExtensions((ExtensionPointName)FileTypeFactory.FILE_TYPE_FACTORY_EP)) {
            try {
                factory.createFileTypes(consumer);
            }
            catch (Throwable t) {
                PluginManager.handleComponentError(t, factory.getClass().getName(), null);
            }
        }
    }

    public FileTypeManagerImpl(MessageBus bus, SchemesManagerFactory schemesManagerFactory) {
        this.myMessageBus = bus;
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)new BaseSchemeProcessor<AbstractFileType>(){

            public AbstractFileType readScheme(@NotNull Document document) throws InvalidDataException {
                SyntaxTable table;
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "readScheme"));
                }
                if (document == null) {
                    throw new InvalidDataException();
                }
                Element root = document.getRootElement();
                if (root == null || !FileTypeManagerImpl.ELEMENT_FILETYPE.equals(root.getName())) {
                    throw new InvalidDataException();
                }
                Element element = root.getChild("highlighting");
                if (element != null && (table = AbstractFileType.readSyntaxTable(element)) != null) {
                    ReadFileType type = new ReadFileType(table, root);
                    String fileTypeName = root.getAttributeValue(FileTypeManagerImpl.ATTRIBUTE_NAME);
                    String fileTypeDescr = root.getAttributeValue(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION);
                    String iconPath = root.getAttributeValue(FileTypeManagerImpl.ATTRIBUTE_ICON);
                    FileTypeManagerImpl.setFileTypeAttributes(fileTypeName, fileTypeDescr, iconPath, type);
                    return type;
                }
                return null;
            }

            public boolean shouldBeSaved(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "shouldBeSaved"));
                }
                return FileTypeManagerImpl.this.shouldBeSavedToFile(fileType);
            }

            public Document writeScheme(@NotNull AbstractFileType fileType) throws WriteExternalException {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "writeScheme"));
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                FileTypeManagerImpl.writeHeader(root, fileType);
                fileType.writeExternal(root);
                Element map = new Element("extensionMap");
                root.addContent(map);
                if (fileType instanceof ImportedFileType) {
                    FileTypeManagerImpl.writeImportedExtensionsMap(map, (ImportedFileType)fileType);
                } else {
                    FileTypeManagerImpl.this.writeExtensionsMap(map, fileType, false);
                }
                return new Document(root);
            }

            public void onSchemeAdded(@NotNull AbstractFileType scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "onSchemeAdded"));
                }
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                if (scheme instanceof ReadFileType) {
                    FileTypeManagerImpl.this.loadFileType((ReadFileType)scheme);
                }
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }

            public void onSchemeDeleted(@NotNull AbstractFileType scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "onSchemeDeleted"));
                }
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations(scheme);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        }, RoamingType.PER_USER);
    }

    private static void writeImportedExtensionsMap(Element map, ImportedFileType type) {
        for (FileNameMatcher matcher : type.getOriginalPatterns()) {
            Element content = AbstractFileType.writeMapping(type, matcher, false);
            if (content == null) continue;
            map.addContent(content);
        }
    }

    private boolean shouldBeSavedToFile(FileType fileType) {
        if (!(fileType instanceof JDOMExternalizable) || !FileTypeManagerImpl.shouldSave(fileType)) {
            return false;
        }
        return !this.myDefaultTypes.contains(fileType) || FileTypeManagerImpl.isDefaultModified(fileType);
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getStdFileType"));
        }
        StandardFileType stdFileType = this.myStandardFileTypes.get(name);
        PlainTextFileType plainTextFileType = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getStdFileType"));
        }
        return plainTextFileType;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{FileTypeManagerImpl.getOrCreateFileTypesDir(), PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = FileTypesBundle.message("filetype.settings.component", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getPresentableName"));
        }
        return string;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
        this.initStandardFileTypes();
        for (StandardFileType pair : this.myStandardFileTypes.values()) {
            this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers);
        }
        for (StandardFileType pair : this.myStandardFileTypes.values()) {
            this.registerReDetectedMappings(pair);
        }
        for (StandardFileType pair : this.myStandardFileTypes.values()) {
            this.bindUnresolvedMappings(pair.fileType);
        }
        if (this.loadAllFileTypes()) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        FileType type = this.myPatternsTable.findAssociatedFileType(fileName);
        FileType fileType = type == null ? UnknownFileType.INSTANCE : type;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        return fileType;
    }

    public static void cacheFileType(@NotNull VirtualFile file, @Nullable FileType fileType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cacheFileType"));
        }
        file.putUserData(FILE_TYPE_KEY, (Object)fileType);
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
        }
        FileType fileType = (FileType)file.getUserData(FILE_TYPE_KEY);
        if (fileType != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
            }
            return fileType2;
        }
        if (file instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file).getAssignedFileType()) != null) {
            FileType fileType3 = fileType;
            if (fileType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
            }
            return fileType3;
        }
        for (int i = 0; i < this.mySpecialFileTypes.size(); ++i) {
            FileTypeIdentifiableByVirtualFile type = this.mySpecialFileTypes.get(i);
            if (!type.isMyFileType(file)) continue;
            FileTypeIdentifiableByVirtualFile fileTypeIdentifiableByVirtualFile = type;
            if (fileTypeIdentifiableByVirtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
            }
            return fileTypeIdentifiableByVirtualFile;
        }
        fileType = this.getFileTypeByFileName(file.getName());
        if (fileType != UnknownFileType.INSTANCE) {
            FileType fileType4 = fileType;
            if (fileType4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
            }
            return fileType4;
        }
        fileType = FileTypeManagerImpl.cachedDetectedFromContent(file);
        if (fileType != null) {
            FileType fileType5 = fileType;
            if (fileType5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
            }
            return fileType5;
        }
        FileType fileType6 = UnknownFileType.INSTANCE;
        if (fileType6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
        }
        return fileType6;
    }

    private static FileType cachedDetectedFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cachedDetectedFromContent"));
        }
        return (FileType)file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
    }

    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
        }
        if (file.isDirectory() || !file.isValid() || file.is(VFileProperty.SPECIAL)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
            }
            return fileType;
        }
        FileType fileType = FileTypeManagerImpl.cachedDetectedFromContent(file);
        if (fileType == null) {
            fileType = FileTypeManagerImpl.detectFromContent(file);
            if (file.getLength() != 0L) {
                file.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType);
            }
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
        }
        return fileType2;
    }

    public static boolean isFileTypeDetectedFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileTypeDetectedFromContent"));
        }
        return FileTypeManagerImpl.cachedDetectedFromContent(file) != null;
    }

    public FileType findFileTypeByName(String fileTypeName) {
        FileType type = this.getStdFileType(fileTypeName);
        if (type == PlainTextFileType.INSTANCE && !fileTypeName.equals(type.getName())) {
            for (FileType fileType : this.getRegisteredFileTypes()) {
                if (!fileTypeName.equals(fileType.getName())) continue;
                return fileType;
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FileType detectFromContent(final @NotNull VirtualFile file) {
        FileType fileType;
        VirtualFileSystem fileSystem;
        block19: {
            block18: {
                block17: {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
                    }
                    long length = file.getLength();
                    if (length != 0L) break block17;
                    FileType fileType2 = UnknownFileType.INSTANCE;
                    if (fileType2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
                    }
                    return fileType2;
                }
                fileSystem = file.getFileSystem();
                if (fileSystem instanceof FileSystemInterface) break block18;
                FileType fileType3 = UnknownFileType.INSTANCE;
                if (fileType3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
                }
                return fileType3;
            }
            if (!SingleRootFileViewProvider.isTooLargeForContentLoading(file)) break block19;
            FileType fileType4 = UnknownFileType.INSTANCE;
            if (fileType4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
            }
            return fileType4;
        }
        try {
            Ref result;
            InputStream inputStream = ((FileSystemInterface)fileSystem).getInputStream(file);
            try {
                result = new Ref((Object)UnknownFileType.INSTANCE);
                FileUtil.processFirstBytes((InputStream)inputStream, (int)8192, (Processor)new Processor<ByteSequence>(){

                    public boolean process(ByteSequence byteSequence) {
                        CharSequence text;
                        boolean isText = FileTypeManagerImpl.guessIfText(file, byteSequence);
                        if (isText) {
                            byte[] bytes = Arrays.copyOf(byteSequence.getBytes(), byteSequence.getLength());
                            text = LoadTextUtil.getTextByBinaryPresentation(bytes, file);
                        } else {
                            text = null;
                        }
                        PlainTextFileType detected = null;
                        for (FileTypeRegistry.FileTypeDetector detector : (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME)) {
                            try {
                                detected = detector.detect(file, byteSequence, text);
                            }
                            catch (Exception e) {
                                LOG.error("Detector " + detector + " (" + detector.getClass() + ") exception occurred:", (Throwable)e);
                            }
                            if (detected != null) break;
                        }
                        if (detected == null) {
                            detected = isText ? PlainTextFileType.INSTANCE : UnknownFileType.INSTANCE;
                        }
                        result.set((Object)detected);
                        return true;
                    }
                });
            }
            finally {
                inputStream.close();
            }
            FileType fileType5 = (FileType)result.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug(file + "; type=" + fileType5.getDescription() + "; " + DETECTED_COUNT.incrementAndGet());
            }
            fileType = fileType5;
        }
        catch (FileNotFoundException e) {
            FileType fileType6 = UnknownFileType.INSTANCE;
            if (fileType6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
            }
            return fileType6;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            FileType fileType7 = UnknownFileType.INSTANCE;
            if (fileType7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
            }
            return fileType7;
        }
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContent"));
        }
        return fileType;
    }

    private static boolean guessIfText(@NotNull VirtualFile file, @NotNull ByteSequence byteSequence) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "guessIfText"));
        }
        if (byteSequence == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "guessIfText"));
        }
        byte[] bytes = byteSequence.getBytes();
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(file, bytes, byteSequence.getLength());
        if (guessed == null) {
            return false;
        }
        file.setBOM((byte[])guessed.third);
        if (guessed.first != null) {
            return true;
        }
        CharsetToolkit.GuessedEncoding guess = (CharsetToolkit.GuessedEncoding)guessed.second;
        return guess != null && guess != CharsetToolkit.GuessedEncoding.INVALID_UTF8;
    }

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileOfType"));
        }
        if (type instanceof FileTypeIdentifiableByVirtualFile) {
            return ((FileTypeIdentifiableByVirtualFile)type).isMyFileType(file);
        }
        return this.getFileTypeByFileName(file.getName()) == type;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByExtension"));
        }
        FileType fileType = this.getFileTypeByFileName("IntelliJ_IDEA_RULES." + extension);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByExtension"));
        }
        return fileType;
    }

    @Override
    public void registerFileType(FileType fileType) {
        this.registerFileType(fileType, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(final @NotNull FileType type, final @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.registerFileTypeWithoutNotification(type, defaultAssociations);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        });
    }

    @Override
    public void unregisterFileType(final FileType fileType) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.unregisterFileTypeWithoutNotification(fileType);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        });
    }

    private void unregisterFileTypeWithoutNotification(FileType fileType) {
        this.removeAllAssociations(fileType);
        this.mySchemesManager.removeScheme((Scheme)fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes.remove(fakeFileType);
        }
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        List fileTypes = this.mySchemesManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(new FileType[fileTypes.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getRegisteredFileTypes"));
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
            }
            return "";
        }
        String string = fileName.substring(index + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set<String> masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getIgnoredFilesList"));
            }
            return "";
        }
        String string = StringUtil.join(masks, (String)";") + ";";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getIgnoredFilesList"));
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setIgnoredFilesList"));
        }
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(String list) {
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileIgnored"));
        }
        return this.myIgnoredPatterns.isIgnored(name);
    }

    public boolean isFileIgnored(@NonNls @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileIgnored"));
        }
        return this.myIgnoredFileCache.isFileIgnored(file);
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociatedExtensions"));
        }
        String[] stringArray = this.myPatternsTable.getAssociatedExtensions(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociatedExtensions"));
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociations"));
        }
        List<FileNameMatcher> list = this.myPatternsTable.getAssociations(type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociations"));
        }
        return list;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        this.removeAssociation(type, matcher, true);
    }

    private void removeAllAssociations(FileType type) {
        this.myPatternsTable.removeAllAssociations(type);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public SchemesManager<FileType, AbstractFileType> getSchemesManager() {
        return this.mySchemesManager;
    }

    @Override
    public void fireFileTypesChanged() {
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "addFileTypeListener"));
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(TOPIC, (Object)listener);
        this.myAdapters.put(listener, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeFileTypeListener"));
        }
        MessageBusConnection connection = this.myAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    private static boolean isDefaultModified(FileType fileType) {
        if (fileType instanceof ExternalizableFileType) {
            return ((ExternalizableFileType)fileType).isModified();
        }
        return true;
    }

    public String getExternalFileName() {
        return ELEMENT_FILETYPES;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        int savedVersion = FileTypeManagerImpl.getVersion(parentNode);
        for (Element o : parentNode.getChildren()) {
            Element e = o;
            if (ELEMENT_FILETYPES.equals(e.getName())) {
                List children = e.getChildren(ELEMENT_FILETYPE);
                for (Object aChildren : children) {
                    Element element = (Element)aChildren;
                    this.loadFileType(element, true, null, false, null);
                }
                continue;
            }
            if (ELEMENT_IGNOREFILES.equals(e.getName())) {
                this.myIgnoredPatterns.setIgnoreMasks(e.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(e.getName())) continue;
            this.readGlobalMappings(e);
        }
        if (savedVersion == 0) {
            this.addIgnore(".svn");
        }
        if (savedVersion < 2) {
            this.restoreStandardFileExtensions();
        }
        if (savedVersion < 4) {
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*.lib");
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 10) {
            this.addIgnore(".bundle");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        this.myIgnoredFileCache.clearCache();
    }

    private void readGlobalMappings(Element e) {
        List<Pair<FileNameMatcher, String>> associations = AbstractFileType.readAssociations(e);
        for (Pair<FileNameMatcher, String> association : associations) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            if (type != null) {
                this.associate(type, (FileNameMatcher)association.getFirst(), false);
                continue;
            }
            this.myUnresolvedMappings.put((FileNameMatcher)association.getFirst(), (String)association.getSecond());
        }
        List<Trinity<FileNameMatcher, String, Boolean>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Trinity<FileNameMatcher, String, Boolean> trinity : removedAssociations) {
            FileType type = this.getFileTypeByName((String)trinity.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)trinity.getFirst();
            if (type != null) {
                this.removeAssociation(type, matcher, false);
                continue;
            }
            this.myUnresolvedRemovedMappings.put(matcher, (Trinity<String, String, Boolean>)Trinity.create((Object)trinity.getSecond(), (Object)this.myUnresolvedMappings.get(matcher), (Object)trinity.getThird()));
        }
    }

    private void readMappingsForFileType(Element e, FileType type) {
        List<Pair<FileNameMatcher, String>> associations = AbstractFileType.readAssociations(e);
        for (Pair<FileNameMatcher, String> association : associations) {
            this.associate(type, (FileNameMatcher)association.getFirst(), false);
        }
        List<Trinity<FileNameMatcher, String, Boolean>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Trinity<FileNameMatcher, String, Boolean> removedAssociation : removedAssociations) {
            this.removeAssociation(type, (FileNameMatcher)removedAssociation.getFirst(), false);
        }
    }

    private void addIgnore(@NonNls String ignoreMask) {
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations(fileType)) {
                FileType defaultFileType = this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations(fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    private static int getVersion(Element node) {
        String verString = node.getAttributeValue(ATTRIBUTE_VERSION);
        if (verString == null) {
            return 0;
        }
        try {
            return Integer.parseInt(verString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        parentNode.setAttribute(ATTRIBUTE_VERSION, String.valueOf(11));
        Element element = new Element(ELEMENT_IGNOREFILES);
        parentNode.addContent(element);
        element.setAttribute(ATTRIBUTE_LIST, this.getIgnoredFilesList());
        Element map = new Element("extensionMap");
        parentNode.addContent(map);
        List<FileType> fileTypes = Arrays.asList(this.getRegisteredFileTypes());
        Collections.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (FileType type : fileTypes) {
            this.writeExtensionsMap(map, type, true);
        }
    }

    private void writeExtensionsMap(Element map, FileType type, boolean specifyTypeName) {
        Element content;
        List<FileNameMatcher> assocs = this.myPatternsTable.getAssociations(type);
        HashSet<FileNameMatcher> defaultAssocs = new HashSet<FileNameMatcher>(this.myInitialAssociations.getAssociations(type));
        for (FileNameMatcher matcher : assocs) {
            if (defaultAssocs.contains(matcher)) {
                defaultAssocs.remove(matcher);
                continue;
            }
            if (!FileTypeManagerImpl.shouldSave(type) || type instanceof ImportedFileType && ((ImportedFileType)type).getOriginalPatterns().contains(matcher) || (content = AbstractFileType.writeMapping(type, matcher, specifyTypeName)) == null) continue;
            map.addContent(content);
        }
        for (FileNameMatcher matcher : defaultAssocs) {
            content = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName, this.isApproved(matcher));
            if (content == null) continue;
            map.addContent(content);
        }
        if (type instanceof ImportedFileType) {
            List<FileNameMatcher> original = ((ImportedFileType)type).getOriginalPatterns();
            for (FileNameMatcher matcher : original) {
                Element content2;
                if (assocs.contains(matcher) || (content2 = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName, this.isApproved(matcher))) == null) continue;
                map.addContent(content2);
            }
        }
    }

    private boolean isApproved(FileNameMatcher matcher) {
        Pair<FileType, Boolean> pair = this.myRemovedMappings.get(matcher);
        return pair != null && (Boolean)pair.getSecond() != false;
    }

    @Nullable
    private FileType getFileTypeByName(String name) {
        return (FileType)this.mySchemesManager.findSchemeByName(name);
    }

    private static List<FileNameMatcher> parse(@NonNls String semicolonDelimited) {
        if (semicolonDelimited == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list = new ArrayList<FileNameMatcher>();
        while (tokenizer.hasMoreTokens()) {
            list.add((FileNameMatcher)new ExtensionFileNameMatcher(tokenizer.nextToken().trim()));
        }
        return list;
    }

    private void registerFileTypeWithoutNotification(FileType fileType, List<FileNameMatcher> matchers) {
        this.mySchemesManager.addNewScheme((Scheme)fileType, true);
        for (FileNameMatcher matcher : matchers) {
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myInitialAssociations.addAssociation(matcher, fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes.add((FileTypeIdentifiableByVirtualFile)fileType);
        }
    }

    private void bindUnresolvedMappings(FileType fileType) {
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedRemovedMappings.keySet())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            if (!Comparing.equal((String)((String)trinity.getFirst()), (String)fileType.getName())) continue;
            this.removeAssociation(fileType, matcher, false);
            this.myUnresolvedRemovedMappings.remove(matcher);
        }
    }

    private boolean loadAllFileTypes() {
        Collection collection = this.mySchemesManager.loadSchemes();
        boolean res = false;
        for (AbstractFileType fileType : collection) {
            ReadFileType readFileType = (ReadFileType)fileType;
            FileType loadedFileType = this.loadFileType(readFileType);
            res |= this.myInitialAssociations.hasAssociationsFor(loadedFileType);
        }
        return res;
    }

    private FileType loadFileType(ReadFileType readFileType) {
        return this.loadFileType(readFileType.getElement(), false, this.mySchemesManager.isShared((Scheme)readFileType) ? readFileType.getExternalInfo() : null, true, readFileType.getExternalInfo().getCurrentFileName());
    }

    private FileType loadFileType(Element typeElement, boolean isDefaults, ExternalInfo info, boolean ignoreExisting, String fileName) {
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue(ATTRIBUTE_ICON);
        String extensionsStr = typeElement.getAttributeValue(ATTRIBUTE_EXTENSIONS);
        FileType type = this.getFileTypeByName(fileTypeName);
        if (isDefaults && !ignoreExisting) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        List<FileNameMatcher> exts = FileTypeManagerImpl.parse(extensionsStr);
        if (type != null && !ignoreExisting) {
            if (isDefaults) {
                return type;
            }
            if (extensionsStr != null) {
                this.removeAllAssociations(type);
                for (FileNameMatcher ext : exts) {
                    this.associate(type, ext, false);
                }
            }
            if (type instanceof JDOMExternalizable) {
                try {
                    ((JDOMExternalizable)type).readExternal(typeElement);
                }
                catch (InvalidDataException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            type = FileTypeManagerImpl.loadCustomFile(typeElement, info, fileName);
            if (type instanceof UserFileType) {
                FileTypeManagerImpl.setFileTypeAttributes(fileTypeName, fileTypeDescr, iconPath, (UserFileType)type);
            }
            this.registerFileTypeWithoutNotification(type, exts);
        }
        if (type instanceof UserFileType) {
            UserFileType ft = (UserFileType)type;
            FileTypeManagerImpl.setFileTypeAttributes(fileTypeName, fileTypeDescr, iconPath, ft);
        }
        if (isDefaults) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild("extensionMap");
            if (extensions != null) {
                this.readMappingsForFileType(extensions, type);
            }
        }
        return type;
    }

    private String filterAlreadyRegisteredExtensions(String semicolonDelimited) {
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            list.add(extension);
        }
        return StringUtil.join(list, (String)";");
    }

    private static FileType loadCustomFile(Element typeElement, ExternalInfo info, String fileName) {
        CustomFileTypeFactory factory;
        SyntaxTable table;
        AbstractFileType type = null;
        Element element = typeElement.getChild("highlighting");
        if (element != null && (table = AbstractFileType.readSyntaxTable(element)) != null) {
            if (info == null) {
                type = new AbstractFileType(table);
                type.getExternalInfo().setCurrentFileName(fileName);
            } else {
                type = new ImportedFileType(table, info);
                ((ImportedFileType)type).readOriginalMatchers(typeElement);
            }
            type.initSupport();
            return type;
        }
        CustomFileTypeFactory[] arr$ = (CustomFileTypeFactory[])Extensions.getExtensions(CustomFileTypeFactory.EP_NAME);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (type = (factory = arr$[i$]).createFileType(typeElement)) == null; ++i$) {
        }
        if (type == null) {
            type = new UserBinaryFileType();
        }
        return type;
    }

    private static void setFileTypeAttributes(String fileTypeName, String fileTypeDescr, String iconPath, UserFileType ft) {
        if (iconPath != null && !StringUtil.isEmptyOrSpaces((String)iconPath)) {
            Icon icon = IconLoader.getIcon((String)iconPath);
            ft.setIcon(icon);
        }
        if (fileTypeDescr != null) {
            ft.setDescription(fileTypeDescr);
        }
        if (fileTypeName != null) {
            ft.setName(fileTypeName);
        }
    }

    private static File getOrCreateFileTypesDir() {
        String directoryPath = PathManager.getConfigPath() + File.separator + ELEMENT_FILETYPES;
        File directory = new File(directoryPath);
        if (!directory.exists() && !directory.mkdir()) {
            LOG.error("Could not create directory: " + directory.getAbsolutePath());
            return null;
        }
        return directory;
    }

    private static boolean shouldSave(FileType fileType) {
        return fileType != FileTypes.UNKNOWN && !fileType.isReadOnly();
    }

    private static void writeHeader(Element root, FileType fileType) {
        root.setAttribute(ATTRIBUTE_BINARY, String.valueOf(fileType.isBinary()));
        root.setAttribute(ATTRIBUTE_DEFAULT_EXTENSION, fileType.getDefaultExtension());
        root.setAttribute(ATTRIBUTE_DESCRIPTION, fileType.getDescription());
        root.setAttribute(ATTRIBUTE_NAME, fileType.getName());
    }

    @NotNull
    public String getComponentName() {
        String string = FileTypeManagerImpl.getFileTypeComponentName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getComponentName"));
        }
        return string;
    }

    public static String getFileTypeComponentName() {
        return PlatformUtils.isIdeaCommunity() ? "CommunityFileTypes" : "FileTypeManager";
    }

    public FileTypeAssocTable getExtensionMap() {
        return this.myPatternsTable;
    }

    public void setPatternsTable(@NotNull Set<FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setPatternsTable"));
        }
        if (assocTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setPatternsTable"));
        }
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemesManager.removeScheme((Scheme)existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemesManager.addNewScheme((Scheme)fileType, true);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
    }

    public void associate(FileType fileType, FileNameMatcher matcher, boolean fireChange) {
        if (!this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(FileType fileType, FileNameMatcher matcher, boolean fireChange) {
        if (this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        FileType type = file.getFileType();
        if (type != UnknownFileType.INSTANCE) {
            return type;
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file.getName());
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file, project);
    }

    private void registerReDetectedMappings(StandardFileType pair) {
        FileType fileType = pair.fileType;
        if (fileType == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            String typeName = this.myUnresolvedMappings.get(matcher);
            if (typeName == null || typeName.equals(fileType.getName())) continue;
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)fileType, (Object)(trinity != null && (Boolean)trinity.third != false ? 1 : 0)));
        }
    }

    Map<FileNameMatcher, Pair<FileType, Boolean>> getRemovedMappings() {
        return this.myRemovedMappings;
    }

    private static class StandardFileType {
        private final FileType fileType;
        private final List<FileNameMatcher> matchers;

        private StandardFileType(FileType fileType, List<FileNameMatcher> matchers) {
            this.fileType = fileType;
            this.matchers = matchers;
        }
    }
}

