/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssocTable<T> {
    private final Map<String, T> myExtensionMappings;
    private final Map<String, T> myExactFileNameMappings;
    private final Map<String, T> myExactFileNameAnyCaseMappings;
    private boolean myHasAnyCaseExactMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;

    private FileTypeAssocTable(Map<String, T> extensionMappings, Map<String, T> exactFileNameMappings, Map<String, T> exactFileNameAnyCaseMappings, List<Pair<FileNameMatcher, T>> matchingMappings) {
        this.myExtensionMappings = new THashMap(extensionMappings);
        this.myExactFileNameMappings = new THashMap(exactFileNameMappings);
        this.myExactFileNameAnyCaseMappings = new THashMap<String, T>(exactFileNameAnyCaseMappings, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE){

            public T remove(Object key) {
                Object removed = super.remove(key);
                FileTypeAssocTable.this.myHasAnyCaseExactMappings = this.size() > 0;
                return removed;
            }

            public T put(String key, T value) {
                Object result = super.put((Object)key, value);
                FileTypeAssocTable.this.myHasAnyCaseExactMappings = true;
                return result;
            }
        };
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    public boolean isAssociatedWith(T type, FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return this.findAssociatedFileType(matcher) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            if (exactFileNameMatcher.isIgnoreCase()) {
                this.myExactFileNameAnyCaseMappings.put(exactFileNameMatcher.getFileName(), type);
            } else {
                this.myExactFileNameMappings.put(exactFileNameMatcher.getFileName(), type);
            }
        } else {
            this.myMatchingMappings.add(new Pair((Object)matcher, type));
        }
    }

    public boolean removeAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return true;
            }
            return false;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String string = exactFileNameMatcher.getFileName();
            Map<String, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (mapToUse.get(string) == type) {
                mapToUse.remove(string);
                return true;
            }
            return false;
        }
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (!matcher.equals(pair.getFirst())) continue;
            this.myMatchingMappings.remove(pair);
            return true;
        }
        return false;
    }

    public boolean removeAllAssociations(T type) {
        boolean changed = this.removeAssociationsFromMap(this.myExtensionMappings, type, false);
        changed = this.removeAssociationsFromMap(this.myExactFileNameAnyCaseMappings, type, changed);
        changed = this.removeAssociationsFromMap(this.myExactFileNameMappings, type, changed);
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (pair.getSecond() != type) continue;
            this.myMatchingMappings.remove(pair);
            changed = true;
        }
        return changed;
    }

    private boolean removeAssociationsFromMap(Map<String, T> extensionMappings, T type, boolean changed) {
        String[] extsStrings;
        Set<String> exts = extensionMappings.keySet();
        for (String s : extsStrings = ArrayUtil.toStringArray(exts)) {
            if (extensionMappings.get(s) != type) continue;
            extensionMappings.remove(s);
            changed = true;
        }
        return changed;
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "findAssociatedFileType"));
        }
        T t = this.myExactFileNameMappings.get(fileName);
        if (t != null) {
            return t;
        }
        if (this.myHasAnyCaseExactMappings && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        int n = this.myMatchingMappings.size();
        for (int i = 0; i < n; ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!((FileNameMatcher)mapping.getFirst()).accept(fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.myExtensionMappings.get(StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)fileName)));
    }

    @Nullable
    public T findAssociatedFileType(FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.myExtensionMappings.get(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            if (exactFileNameMatcher.isIgnoreCase()) {
                return this.myExactFileNameAnyCaseMappings.get(exactFileNameMatcher.getFileName());
            }
            return this.myExactFileNameMappings.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public String[] getAssociatedExtensions(T type) {
        Map<String, T> extMap = this.myExtensionMappings;
        ArrayList<String> exts = new ArrayList<String>();
        for (String ext : extMap.keySet()) {
            if (extMap.get(ext) != type) continue;
            exts.add(ext);
        }
        String[] stringArray = ArrayUtil.toStringArray(exts);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociatedExtensions"));
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        FileTypeAssocTable<T> fileTypeAssocTable = new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myMatchingMappings);
        if (fileTypeAssocTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "copy"));
        }
        return fileTypeAssocTable;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(T type) {
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher((String)entry.getKey()));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher((String)entry.getKey(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExtensionFileNameMatcher((String)entry.getKey()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociations"));
        }
        return arrayList;
    }

    public boolean hasAssociationsFor(T fileType) {
        if (this.myExtensionMappings.values().contains(fileType)) {
            return true;
        }
        if (this.myExactFileNameMappings.values().contains(fileType)) {
            return true;
        }
        if (this.myExactFileNameAnyCaseMappings.values().contains(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        if (!((Object)this.myExtensionMappings).equals(that.myExtensionMappings)) {
            return false;
        }
        if (!((Object)this.myMatchingMappings).equals(that.myMatchingMappings)) {
            return false;
        }
        if (!((Object)this.myExactFileNameMappings).equals(that.myExactFileNameMappings)) {
            return false;
        }
        return ((Object)this.myExactFileNameAnyCaseMappings).equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = ((Object)this.myExtensionMappings).hashCode();
        result = 31 * result + ((Object)this.myMatchingMappings).hashCode();
        result = 31 * result + ((Object)this.myExactFileNameMappings).hashCode();
        result = 31 * result + ((Object)this.myExactFileNameAnyCaseMappings).hashCode();
        return result;
    }
}

