/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorPsiDataProvider
implements EditorDataProvider {
    @Nullable
    public Object getData(@NotNull String dataId, @NotNull Editor e, @NotNull VirtualFile file) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getData"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getData"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getData"));
        }
        if (!file.isValid()) {
            return null;
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()))) {
            if (PsiDocumentManager.getInstance((Project)e.getProject()).isUncommited(e.getDocument())) {
                return e;
            }
            return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(e, TextEditorPsiDataProvider.getPsiFile(e, file));
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_ELEMENT.getName()))) {
            return TextEditorPsiDataProvider.getPsiElementIn((Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, file), file);
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiElementIn(e, file);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.LANGUAGE.getName()))) {
            PsiFile psiFile = (PsiFile)this.getData(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()), e, file);
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, file);
            if (psiFile == null || editor == null) {
                return null;
            }
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(editor, psiFile);
        }
        if (LangDataKeys.LANGUAGE.is(dataId)) {
            PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(e, file);
            if (psiFile == null) {
                return null;
            }
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(e, psiFile);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.VIRTUAL_FILE.getName()))) {
            PsiFile psiFile = (PsiFile)this.getData(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()), e, file);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()))) {
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, file);
            if (editor == null) {
                return null;
            }
            Project project = editor.getProject();
            if (project == null) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (LangDataKeys.PSI_FILE.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiFile(e, file);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            PsiDirectory psiDirectory;
            PsiFile psiFile = PsiManager.getInstance((Project)e.getProject()).findFile(file);
            PsiDirectory psiDirectory2 = psiDirectory = psiFile != null ? psiFile.getParent() : null;
            if (psiDirectory != null && psiDirectory.isPhysical()) {
                return new IdeView(){

                    public void selectElement(PsiElement element) {
                        Editor editor = EditorHelper.openInEditor(element);
                        if (editor != null) {
                            ToolWindowManager.getInstance((Project)element.getProject()).activateEditorComponent();
                        }
                    }

                    public PsiDirectory[] getDirectories() {
                        return new PsiDirectory[]{psiDirectory};
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }
                };
            }
        }
        if (LangDataKeys.CONTEXT_LANGUAGES.is(dataId)) {
            return this.computeLanguages(e, file);
        }
        return null;
    }

    private static Language getLanguageAtCurrentPositionInEditor(Editor editor, PsiFile psiFile) {
        int mostProbablyCorrectLanguageOffset;
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = editor.getCaretModel().getOffset();
        int n = mostProbablyCorrectLanguageOffset = caretOffset == selectionModel.getSelectionStart() || caretOffset == selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretOffset;
        if (selectionModel.hasSelection()) {
            return TextEditorPsiDataProvider.getLanguageAtOffset(psiFile, mostProbablyCorrectLanguageOffset, selectionModel.getSelectionEnd());
        }
        return PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)mostProbablyCorrectLanguageOffset);
    }

    private static Language getLanguageAtOffset(PsiFile psiFile, int mostProbablyCorrectLanguageOffset, int end) {
        int incremented;
        PsiElement elt = psiFile.findElementAt(mostProbablyCorrectLanguageOffset);
        if (elt == null) {
            return psiFile.getLanguage();
        }
        if (elt instanceof PsiWhiteSpace && (incremented = elt.getTextRange().getEndOffset() + 1) <= end) {
            return TextEditorPsiDataProvider.getLanguageAtOffset(psiFile, incremented, end);
        }
        return PsiUtilCore.findLanguageFromElement((PsiElement)elt);
    }

    @Nullable
    private static PsiElement getPsiElementIn(@NotNull Editor editor, @NotNull VirtualFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getPsiElementIn"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getPsiElementIn"));
        }
        PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(editor, file);
        if (psiFile == null) {
            return null;
        }
        try {
            return TargetElementUtilBase.findTargetElement(editor, TargetElementUtilBase.getInstance().getReferenceSearchFlags());
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull Editor e, @NotNull VirtualFile file) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getPsiFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "getPsiFile"));
        }
        if (!file.isValid()) {
            return null;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile != null && psiFile.isValid() ? psiFile : null;
    }

    private Language[] computeLanguages(@NotNull Editor editor, @NotNull VirtualFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "computeLanguages"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider", "computeLanguages"));
        }
        LinkedHashSet set = new LinkedHashSet(4);
        Language injectedLanguage = (Language)this.getData(AnActionEvent.injectedId((String)LangDataKeys.LANGUAGE.getName()), editor, file);
        ContainerUtil.addIfNotNull((Object)injectedLanguage, set);
        Language language = (Language)this.getData(LangDataKeys.LANGUAGE.getName(), editor, file);
        ContainerUtil.addIfNotNull((Object)language, set);
        PsiFile psiFile = (PsiFile)this.getData(LangDataKeys.PSI_FILE.getName(), editor, file);
        if (psiFile != null) {
            ContainerUtil.addIfNotNull((Object)psiFile.getViewProvider().getBaseLanguage(), set);
        }
        return set.toArray(new Language[set.size()]);
    }
}

