/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider");
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        if (!this.accept(project, file)) {
            LOG.error("Cannot open text editor for " + file);
        }
        PsiAwareTextEditorImpl psiAwareTextEditorImpl = new PsiAwareTextEditorImpl(project, file, this);
        if (psiAwareTextEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        return psiAwareTextEditorImpl;
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element, final @NotNull Project project, final @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        TextEditorState state = (TextEditorState)super.readState(element, project, file);
        Element child = element.getChild(FOLDING_ELEMENT);
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (child != null) {
            if (document == null) {
                final Element detachedStateCopy = child.clone();
                state.setDelayedFoldState(new Producer<CodeFoldingState>(){

                    public CodeFoldingState produce() {
                        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                        return document == null ? null : CodeFoldingManager.getInstance(project).readFoldingState(detachedStateCopy, document);
                    }
                });
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project).readFoldingState(child, document));
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        return textEditorState;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        super.writeState(_state, project, element);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException e1) {
                // empty catch block
            }
            element.addContent(e);
        }
    }

    @Override
    protected TextEditorState getStateImpl(Project project, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "getStateImpl"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "getStateImpl"));
        }
        TextEditorState state = super.getStateImpl(project, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project != null && !project.isDisposed() && !editor.isDisposed() && project.isInitialized()) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                state.setFoldingState(CodeFoldingManager.getInstance(project).saveFoldingState(editor));
            } else {
                state.setFoldingState(null);
            }
        }
        return state;
    }

    @Override
    protected void setStateImpl(final Project project, final Editor editor, TextEditorState state) {
        super.setStateImpl(project, editor, state);
        final CodeFoldingState foldState = state.getFoldingState();
        if (project != null && foldState != null) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            CodeFoldingManager.getInstance(project).restoreFoldingState(editor, foldState);
                        }
                    });
                }
            });
        }
    }

    @Override
    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createWrapperForEditor"));
        }
        PsiAwareEditorWrapper psiAwareEditorWrapper = new PsiAwareEditorWrapper(editor);
        if (psiAwareEditorWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createWrapperForEditor"));
        }
        return psiAwareEditorWrapper;
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider$PsiAwareEditorWrapper", "<init>"));
            }
            super(PsiAwareTextEditorProvider.this, editor);
            Project project = editor.getProject();
            this.myBackgroundHighlighter = project == null ? null : new TextEditorBackgroundHighlighter(project, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }
    }
}

