/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class OpenFilesActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/OpenFilesActivity", "runActivity"));
        }
        final FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (fileEditorManager instanceof FileEditorManagerImpl) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
                    manager.getMainSplitters().openFiles();
                    manager.initDockableContentFactory();
                }
            };
            if (Registry.is((String)"ide.open.editors.asynchronously")) {
                runnable.run();
            } else {
                UIUtil.invokeLaterIfNeeded((Runnable)runnable);
            }
        }
    }
}

