/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class HistoryEntry {
    static final String TAG = "entry";
    private static final String FILE_ATTR = "file";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    private static final String SELECTED_ATTR_VALUE = "selected";
    private static final String STATE_ELEMENT = "state";
    public final VirtualFile myFile;
    public FileEditorProvider mySelectedProvider;
    private final HashMap<FileEditorProvider, FileEditorState> myProvider2State;

    public HistoryEntry(@NotNull VirtualFile file, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (selectedProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        this.myFile = file;
        this.myProvider2State = new HashMap();
        this.mySelectedProvider = selectedProvider;
        for (int i = 0; i < providers.length; ++i) {
            this.putState(providers[i], states[i]);
        }
    }

    public HistoryEntry(Project project, Element e) throws InvalidDataException {
        this(project, e, false);
    }

    public HistoryEntry(Project project, Element e, boolean ensureDocumentCreated) throws InvalidDataException {
        if (!e.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + e);
        }
        String url = e.getAttributeValue(FILE_ATTR);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            throw new InvalidDataException("No file exists: " + url);
        }
        this.myFile = file;
        this.myProvider2State = new HashMap();
        if (ensureDocumentCreated) {
            FileDocumentManager.getInstance().getDocument(this.myFile);
        }
        List providers = e.getChildren(PROVIDER_ELEMENT);
        for (Object provider1 : providers) {
            Element stateElement;
            Element _e = (Element)provider1;
            String typeId = _e.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider == null) continue;
            if (Boolean.valueOf(_e.getAttributeValue(SELECTED_ATTR_VALUE)).booleanValue()) {
                this.mySelectedProvider = provider;
            }
            if ((stateElement = _e.getChild(STATE_ELEMENT)) == null) {
                throw new InvalidDataException();
            }
            FileEditorState state = provider.readState(stateElement, project, file);
            this.putState(provider, state);
        }
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "getState"));
        }
        return (FileEditorState)this.myProvider2State.get((Object)provider);
    }

    public void putState(@NotNull FileEditorProvider provider, @NotNull FileEditorState state) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "putState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "putState"));
        }
        this.myProvider2State.put((Object)provider, (Object)state);
    }

    public Element writeExternal(Element element, Project project) {
        Element e = new Element(TAG);
        element.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFile.getUrl());
        for (Map.Entry entry : this.myProvider2State.entrySet()) {
            FileEditorProvider provider = (FileEditorProvider)entry.getKey();
            Element providerElement = new Element(PROVIDER_ELEMENT);
            if (provider.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            providerElement.addContent(stateElement);
            provider.writeState((FileEditorState)entry.getValue(), project, stateElement);
            e.addContent(providerElement);
        }
        return e;
    }
}

