/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorManagerImpl
extends FileEditorManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
    private static final Key<LocalFileSystem.WatchRequest> WATCH_REQUEST_KEY = Key.create((String)"WATCH_REQUEST_KEY");
    private static final Key<Boolean> DUMB_AWARE = Key.create((String)"DUMB_AWARE");
    private static final FileEditor[] EMPTY_EDITOR_ARRAY = new FileEditor[0];
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    public static final Key<Boolean> CLOSING_TO_REOPEN = Key.create((String)"CLOSING_TO_REOPEN");
    public static final String FILE_EDITOR_MANAGER = "FileEditorManager";
    private volatile JPanel myPanels;
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final List<Pair<VirtualFile, EditorWindow>> mySelectionHistory = new ArrayList<Pair<VirtualFile, EditorWindow>>();
    private WeakReference<EditorComposite> myLastSelectedComposite = new WeakReference<Object>(null);
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, null);
    private final BusyObject.Impl.Simple myBusyObject = new BusyObject.Impl.Simple();
    private final MyEditorPropertyChangeListener myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
    private final DockManager myDockManager;
    private DockableEditorContainerFactory myContentFactory;
    private final Object myInitLock = new Object();
    private final MessageListenerList<FileEditorManagerListener> myListenerList;

    public FileEditorManagerImpl(Project project, DockManager dockManager) {
        this.myProject = project;
        this.myDockManager = dockManager;
        this.myListenerList = new MessageListenerList(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (((FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)).length > 0) {
            this.myListenerList.add((Object)new FileEditorManagerAdapter(){

                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$1", "selectionChanged"));
                    }
                    EditorsSplitters splitters = FileEditorManagerImpl.this.getSplitters();
                    FileEditorManagerImpl.this.openAssociatedFile(event.getNewFile(), splitters.getCurrentWindow(), splitters);
                }
            });
        }
        this.myQueue.setTrackUiActivity(true);
    }

    void initDockableContentFactory() {
        if (this.myContentFactory != null) {
            return;
        }
        this.myContentFactory = new DockableEditorContainerFactory(this.myProject, this, this.myDockManager);
        this.myDockManager.register("file-editors", (DockContainerFactory)this.myContentFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myContentFactory);
    }

    public static boolean isDumbAware(FileEditor editor) {
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE)) && (!(editor instanceof PossiblyDumbAware) || ((PossiblyDumbAware)editor).isDumbAware());
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanels;
    }

    @NotNull
    public EditorsSplitters getMainSplitters() {
        this.initUI();
        EditorsSplitters editorsSplitters = this.mySplitters;
        if (editorsSplitters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getMainSplitters"));
        }
        return editorsSplitters;
    }

    public Set<EditorsSplitters> getAllSplitters() {
        HashSet<EditorsSplitters> all = new HashSet<EditorsSplitters>();
        all.add(this.getMainSplitters());
        Set dockContainers = this.myDockManager.getContainers();
        for (DockContainer each : dockContainers) {
            if (!(each instanceof DockableEditorTabbedContainer)) continue;
            all.add(((DockableEditorTabbedContainer)each).getSplitters());
        }
        return Collections.unmodifiableSet(all);
    }

    private AsyncResult<EditorsSplitters> getActiveSplitters(boolean syncUsage) {
        final boolean async = Registry.is((String)"ide.windowSystem.asyncSplitters") && !syncUsage;
        final AsyncResult result = new AsyncResult();
        final IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DockContainer container;
                if (FileEditorManagerImpl.this.myProject.isDisposed()) {
                    result.setRejected();
                    return;
                }
                Component focusOwner = fm.getFocusOwner();
                if (focusOwner == null && !async) {
                    focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                }
                if (focusOwner == null && !async) {
                    focusOwner = fm.getLastFocusedFor(fm.getLastFocusedFrame());
                }
                if ((container = FileEditorManagerImpl.this.myDockManager.getContainerFor(focusOwner)) == null && !async) {
                    focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    container = FileEditorManagerImpl.this.myDockManager.getContainerFor(focusOwner);
                }
                if (container instanceof DockableEditorTabbedContainer) {
                    result.setDone((Object)((DockableEditorTabbedContainer)container).getSplitters());
                } else {
                    result.setDone((Object)FileEditorManagerImpl.this.getMainSplitters());
                }
            }
        };
        if (async) {
            fm.doWhenFocusSettlesDown(run);
        } else {
            run.run();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        if (this.myPanels == null) {
            Object object = this.myInitLock;
            synchronized (object) {
                if (this.myPanels == null) {
                    this.myPanels = new JPanel(new BorderLayout());
                    this.myPanels.setOpaque(false);
                    this.myPanels.setBorder(new MyBorder());
                    this.mySplitters = new EditorsSplitters(this, this.myDockManager, true);
                    this.myPanels.add((Component)((Object)this.mySplitters), "Center");
                }
            }
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public Color getFileColor(@NotNull VirtualFile file) {
        Color statusColor;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getFileColor"));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        Color color = statusColor = fileStatusManager != null ? fileStatusManager.getStatus(file).getColor() : UIUtil.getLabelForeground();
        if (statusColor == null) {
            statusColor = UIUtil.getLabelForeground();
        }
        return statusColor;
    }

    public boolean isProblem(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isProblem"));
        }
        return false;
    }

    public String getFileTooltipText(VirtualFile file) {
        return FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "updateFilePresentation"));
        }
        if (!this.isFileOpen(file)) {
            return;
        }
        this.updateFileColor(file);
        this.updateFileIcon(file);
        this.updateFileName(file);
        this.updateFileBackgroundColor(file);
    }

    private void updateFileColor(VirtualFile file) {
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileColor(file);
        }
    }

    private void updateFileBackgroundColor(VirtualFile file) {
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileBackgroundColor(file);
        }
    }

    protected void updateFileIcon(VirtualFile file) {
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileIcon(file);
        }
    }

    void updateFileName(final @Nullable VirtualFile file) {
        this.myQueue.queue(new Update("UpdateFileName " + (file == null ? "" : file.getPath())){

            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file == null ? super.isExpired() : !file.isValid());
            }

            public void run() {
                Set<EditorsSplitters> all = FileEditorManagerImpl.this.getAllSplitters();
                for (EditorsSplitters each : all) {
                    each.updateFileName(file);
                }
            }
        });
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getFile"));
        }
        EditorWithProviderComposite editorComposite = this.getEditorComposite(editor);
        if (editorComposite != null) {
            return editorComposite.getFile();
        }
        return null;
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = ((EditorsSplitters)((Object)this.getActiveSplitters(true).getResult())).getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = ((EditorsSplitters)((Object)this.getActiveSplitters(true).getResult())).getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    public int getWindowSplitCount() {
        return ((EditorsSplitters)((Object)this.getActiveSplitters(true).getResult())).getSplitCount();
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        Set<EditorsSplitters> splitters = this.getAllSplitters();
        if (splitters.size() > 1) {
            return true;
        }
        return this.getWindowSplitCount() > 1;
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        ArrayList<EditorWindow> windows = new ArrayList<EditorWindow>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            EditorWindow[] eachList = each.getWindows();
            windows.addAll(Arrays.asList(eachList));
        }
        EditorWindow[] editorWindowArray = windows.toArray(new EditorWindow[windows.size()]);
        if (editorWindowArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getWindows"));
        }
        return editorWindowArray;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getNextWindow"));
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getPrevWindow"));
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + windows.length - 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation, true, null, false);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation, true, null, false);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public void flipTabs() {
        this.myPanels.revalidate();
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    private void setTabsMode(boolean mode) {
        if (this.tabsMode() != mode) {
            this.flipTabs();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return ((EditorsSplitters)((Object)this.getActiveSplitters(true).getResult())).getCurrentFile();
    }

    @Override
    @NotNull
    public AsyncResult<EditorWindow> getActiveWindow() {
        AsyncResult<EditorWindow> asyncResult = this._getActiveWindow(false);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getActiveWindow"));
        }
        return asyncResult;
    }

    @NotNull
    private AsyncResult<EditorWindow> _getActiveWindow(boolean now) {
        AsyncResult asyncResult = this.getActiveSplitters(now).subResult((Function)new Function<EditorsSplitters, EditorWindow>(){

            public EditorWindow fun(EditorsSplitters splitters) {
                return splitters.getCurrentWindow();
            }
        });
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "_getActiveWindow"));
        }
        return asyncResult;
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return (EditorWindow)this._getActiveWindow(true).getResult();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        ((EditorsSplitters)((Object)this.getActiveSplitters(true).getResult())).setCurrentWindow(window, true);
    }

    public void closeFile(final @NotNull VirtualFile file, final @NotNull EditorWindow window, final boolean transferFocus) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                if (window.isFileOpen(file)) {
                    LocalFileSystem.WatchRequest request;
                    window.closeFile(file, true, transferFocus);
                    List<EditorWindow> windows = window.getOwner().findWindows(file);
                    if (windows.isEmpty() && (request = (LocalFileSystem.WatchRequest)file.getUserData(WATCH_REQUEST_KEY)) != null) {
                        LocalFileSystem.getInstance().removeWatchedRoot(request);
                    }
                }
            }
        }, IdeBundle.message((String)"command.close.active.editor", (Object[])new Object[0]), null);
        this.removeSelectionRecord(file, window);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file, @NotNull EditorWindow window) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        this.closeFile(file, window, true);
    }

    public void closeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        this.closeFile(file, true, false);
    }

    public void closeFile(final @NotNull VirtualFile file, final boolean moveFocus, final boolean closeAllCopies) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        LocalFileSystem.WatchRequest request = (LocalFileSystem.WatchRequest)file.getUserData(WATCH_REQUEST_KEY);
        if (request != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(request);
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                FileEditorManagerImpl.this.closeFileImpl(file, moveFocus, closeAllCopies);
            }
        }, "", null);
    }

    private void closeFileImpl(final @NotNull VirtualFile file, final boolean moveFocus, boolean closeAllCopies) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFileImpl"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        this.runChange(new FileEditorManagerChange(){

            @Override
            public void run(EditorsSplitters splitters) {
                splitters.closeFile(file, moveFocus);
            }
        }, closeAllCopies ? null : (EditorsSplitters)((Object)this.getActiveSplitters(true).getResult()));
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file, boolean focusEditor, boolean searchForSplitter) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        if (!file.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (FileEditorManagerImpl.isOpenInNewWindow(EventQueue.getCurrentEvent())) {
            Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileInNewWindow(file);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
            }
            return pair;
        }
        EditorWindow wndToOpenIn = null;
        if (searchForSplitter) {
            Set<EditorsSplitters> all = this.getAllSplitters();
            EditorsSplitters active = (EditorsSplitters)((Object)this.getActiveSplitters(true).getResult());
            if (active.getCurrentWindow() != null && active.getCurrentWindow().isFileOpen(file)) {
                wndToOpenIn = active.getCurrentWindow();
            } else {
                for (EditorsSplitters splitters : all) {
                    EditorWindow window = splitters.getCurrentWindow();
                    if (window == null || !window.isFileOpen(file)) continue;
                    wndToOpenIn = window;
                    break;
                }
            }
        } else {
            wndToOpenIn = this.getSplitters().getCurrentWindow();
        }
        EditorsSplitters splitters = this.getSplitters();
        if (wndToOpenIn == null) {
            wndToOpenIn = splitters.getOrCreateCurrentWindow(file);
        }
        this.openAssociatedFile(file, wndToOpenIn, splitters);
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(wndToOpenIn, file, focusEditor);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        return pair;
    }

    public Pair<FileEditor[], FileEditorProvider[]> openFileInNewWindow(VirtualFile file) {
        return ((DockManagerImpl)DockManager.getInstance((Project)this.getProject())).createNewDockContainerFor(file, this);
    }

    private static boolean isOpenInNewWindow(AWTEvent event) {
        if (event instanceof MouseEvent && ((MouseEvent)event).isShiftDown()) {
            return true;
        }
        return event instanceof KeyEvent && ((KeyEvent)event).getKeyCode() == 10 && ((KeyEvent)event).isShiftDown();
    }

    private void openAssociatedFile(VirtualFile file, EditorWindow wndToOpenIn, EditorsSplitters splitters) {
        EditorWindow[] windows = splitters.getWindows();
        if (file != null && windows.length == 2) {
            for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, file);
                if (associatedFile == null) continue;
                EditorWindow currentWindow = splitters.getCurrentWindow();
                int idx = windows[0] == wndToOpenIn ? 1 : 0;
                this.openFileImpl2(windows[idx], associatedFile, false);
                if (currentWindow == null) break;
                splitters.setCurrentWindow(currentWindow, false);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file, boolean focusEditor, @NotNull EditorWindow window) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        if (!file.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file);
        }
        FileEditorManagerImpl.assertDispatchThread();
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(window, file, focusEditor);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        return pair;
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(final @NotNull EditorWindow window, final @NotNull VirtualFile file, final boolean focusEditor) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl2"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl2"));
        }
        final Ref result = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                result.set(FileEditorManagerImpl.this.openFileImpl3(window, file, focusEditor, null, true));
            }
        }, "", null);
        Pair pair = (Pair)result.get();
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl2"));
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull EditorWindow window, @NotNull VirtualFile file, boolean focusEditor, @Nullable HistoryEntry entry, boolean current) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl3"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl3"));
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl4(window, file, focusEditor, entry, current, -1);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl3"));
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl4(final @NotNull EditorWindow window, final @NotNull VirtualFile file, boolean focusEditor, @Nullable HistoryEntry entry, boolean current, int index) {
        int i;
        Object[] providers;
        FileEditor[] editors;
        EditorWithProviderComposite newSelectedComposite;
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
        }
        boolean newEditorCreated = false;
        boolean open = window.isFileOpen(file);
        if (open) {
            newSelectedComposite = window.findFileComposite(file);
            LOG.assertTrue(newSelectedComposite != null);
            editors = newSelectedComposite.getEditors();
            providers = newSelectedComposite.getProviders();
        } else {
            if (UISettings.getInstance().EDITOR_TAB_PLACEMENT == 0 || UISettings.getInstance().PRESENTATION_MODE) {
                for (EditorWithProviderComposite composite : window.getEditors()) {
                    Disposer.dispose((Disposable)composite);
                }
            }
            FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
            providers = editorProviderManager.getProviders(this.myProject, file);
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                List dumbAware = ContainerUtil.findAll((Object[])providers, (Condition)new Condition<FileEditorProvider>(){

                    public boolean value(FileEditorProvider fileEditorProvider) {
                        return DumbService.isDumbAware((Object)fileEditorProvider);
                    }
                });
                providers = dumbAware.toArray(new FileEditorProvider[dumbAware.size()]);
            }
            if (providers.length == 0) {
                Pair pair = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
                }
                return pair;
            }
            newEditorCreated = true;
            ((FileEditorManagerListener.Before)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER)).beforeFileOpened((FileEditorManager)this, file);
            editors = new FileEditor[providers.length];
            for (i = 0; i < providers.length; ++i) {
                try {
                    Object provider = providers[i];
                    LOG.assertTrue(provider != null, (Object)("Provider for file " + file + " is null. All providers: " + Arrays.asList(providers)));
                    LOG.assertTrue(provider.accept(this.myProject, file), (Object)("Provider " + provider + " doesn't accept file " + file));
                    FileEditor editor = provider.createEditor(this.myProject, file);
                    LOG.assertTrue(editor != null);
                    LOG.assertTrue(editor.isValid());
                    editors[i] = editor;
                    editor.addPropertyChangeListener((PropertyChangeListener)this.myEditorPropertyChangeListener);
                    editor.putUserData(DUMB_AWARE, (Object)DumbService.isDumbAware((Object)provider));
                    if (!current || !(editor instanceof TextEditorImpl)) continue;
                    ((TextEditorImpl)editor).initFolding();
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
            }
            newSelectedComposite = new EditorWithProviderComposite(file, editors, (FileEditorProvider[])providers, this);
            if (index >= 0) {
                newSelectedComposite.getFile().putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
            }
        }
        window.setEditor(newSelectedComposite, focusEditor);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (i = 0; i < editors.length; ++i) {
            final FileEditor editor = editors[i];
            if (editor instanceof TextEditor) {
                ((EditorEx)((TextEditor)editor).getEditor()).stopOptimizedScrolling();
            }
            Object provider = providers[i];
            FileEditorState state = null;
            if (entry != null) {
                state = entry.getState((FileEditorProvider)provider);
            }
            if (state == null && !open) {
                state = editorHistoryManager.getState(file, (FileEditorProvider)provider);
            }
            if (state == null) continue;
            if (!FileEditorManagerImpl.isDumbAware(editor)) {
                final FileEditorState finalState = state;
                DumbService.getInstance((Project)this.getProject()).runWhenSmart(new Runnable(){

                    @Override
                    public void run() {
                        editor.setState(finalState);
                    }
                });
                continue;
            }
            editor.setState(state);
        }
        FileEditorProvider[] _providers = newSelectedComposite.getProviders();
        FileEditorProvider selectedProvider = entry == null ? ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).getSelectedFileEditorProvider(editorHistoryManager, file, _providers) : entry.mySelectedProvider;
        if (selectedProvider != null) {
            FileEditor[] _editors = newSelectedComposite.getEditors();
            for (int i2 = _editors.length - 1; i2 >= 0; --i2) {
                FileEditorProvider provider = _providers[i2];
                if (!provider.equals(selectedProvider)) continue;
                newSelectedComposite.setSelectedEditor(i2);
                break;
            }
        }
        window.getOwner().setCurrentWindow(window, focusEditor);
        window.getOwner().afterFileOpen(file);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                newSelectedComposite.getSelectedEditor().selectNotify();
            }
        });
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (newEditorCreated) {
            if (window.isShowing()) {
                window.setPaintBlocked(true);
            }
            this.notifyPublisher(new Runnable(){

                @Override
                public void run() {
                    window.setPaintBlocked(false);
                    if (FileEditorManagerImpl.this.isFileOpen(file)) {
                        ((FileEditorManagerListener)FileEditorManagerImpl.this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)FileEditorManagerImpl.this, file);
                    }
                }
            });
            VirtualFile parentDir = file.getParent();
            if (parentDir != null) {
                LocalFileSystem.WatchRequest request = LocalFileSystem.getInstance().addRootToWatch(parentDir.getPath(), false);
                file.putUserData(WATCH_REQUEST_KEY, (Object)request);
            }
        }
        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
        if (!ApplicationManagerEx.getApplicationEx().isUnitTestMode() && focusEditor) {
            window.setAsCurrentWindow(true);
            ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
            focusManager.toFront((JComponent)((Object)window.getOwner()));
        }
        this.updateFileName(file);
        IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        Pair pair = Pair.create((Object)editors, (Object)providers);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
        }
        return pair;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "notifyPublisher"));
        }
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        final ActionCallback done = new ActionCallback();
        ActionCallback actionCallback = this.myBusyObject.execute(new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                focusManager.doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(FileEditorManagerImpl.this.myProject){

                    public void run() {
                        runnable.run();
                        done.setDone();
                    }
                });
                ActionCallback actionCallback = done;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$13", "run"));
                }
                return actionCallback;
            }
        });
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "notifyPublisher"));
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file, String fileEditorProviderId) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "setSelectedEditor"));
        }
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file);
        if (composite == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = (FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond();
        for (int i = 0; i < editorProviders.length; ++i) {
            if (!editorProviders[i].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i])) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
        }
    }

    @Nullable
    EditorWithProviderComposite newEditorComposite(VirtualFile file) {
        if (file == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file);
        FileEditor[] editors = new FileEditor[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            FileEditor editor;
            FileEditorProvider provider = providers[i];
            LOG.assertTrue(provider != null);
            LOG.assertTrue(provider.accept(this.myProject, file));
            editors[i] = editor = provider.createEditor(this.myProject, file);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener((PropertyChangeListener)this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file, editors, providers, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i = 0; i < editors.length; ++i) {
            FileEditorProvider provider;
            FileEditorState state;
            FileEditor editor = editors[i];
            if (editor instanceof TextEditor) {
                // empty if block
            }
            if ((state = editorHistoryManager.getState(file, provider = providers[i])) == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    @NotNull
    public List<FileEditor> openEditor(final @NotNull OpenFileDescriptor descriptor, final boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openEditor"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor.getFile() instanceof VirtualFileWindow) {
            VirtualFileWindow delegate = (VirtualFileWindow)descriptor.getFile();
            int hostOffset = delegate.getDocumentWindow().injectedToHost(descriptor.getOffset());
            OpenFileDescriptor realDescriptor = new OpenFileDescriptor(descriptor.getProject(), delegate.getDelegate(), hostOffset);
            realDescriptor.setUseCurrentWindow(descriptor.isUseCurrentWindow());
            List<FileEditor> list = this.openEditor(realDescriptor, focusEditor);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openEditor"));
            }
            return list;
        }
        SmartList result = new SmartList();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            public void run() {
                Object editor;
                int i$;
                VirtualFile file = descriptor.getFile();
                Object[] editors = FileEditorManagerImpl.this.openFile(file, focusEditor, !descriptor.isUseCurrentWindow());
                ContainerUtil.addAll((Collection)this.val$result, (Object[])editors);
                boolean navigated = false;
                Object[] arr$ = editors;
                int len$ = arr$.length;
                for (i$ = 0; !(i$ >= len$ || (editor = arr$[i$]) instanceof NavigatableFileEditor && FileEditorManagerImpl.this.getSelectedEditor(descriptor.getFile()) == editor && (navigated = FileEditorManagerImpl.this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor))); ++i$) {
                }
                if (!navigated) {
                    arr$ = editors;
                    len$ = arr$.length;
                    for (i$ = 0; !(i$ >= len$ || (editor = arr$[i$]) instanceof NavigatableFileEditor && FileEditorManagerImpl.this.getSelectedEditor(descriptor.getFile()) != editor && FileEditorManagerImpl.this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor)); ++i$) {
                    }
                }
            }
        }, "", null);
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openEditor"));
        }
        return smartList;
    }

    private boolean navigateAndSelectEditor(NavigatableFileEditor editor, OpenFileDescriptor descriptor) {
        if (editor.canNavigateTo((Navigatable)descriptor)) {
            this.setSelectedEditor((FileEditor)editor);
            editor.navigateTo((Navigatable)descriptor);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(FileEditor editor) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite == null) {
            return;
        }
        FileEditor[] editors = composite.getEditors();
        for (int i = 0; i < editors.length; ++i) {
            FileEditor each = editors[i];
            if (editor != each) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getProject"));
        }
        return project;
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openTextEditor"));
        }
        List<FileEditor> fileEditors = this.openEditor(descriptor, focusEditor);
        for (FileEditor fileEditor : fileEditors) {
            if (!(fileEditor instanceof TextEditor)) continue;
            this.setSelectedEditor(descriptor.getFile(), TextEditorProvider.getInstance().getEditorTypeId());
            Editor editor = ((TextEditor)fileEditor).getEditor();
            return this.getOpenedEditor(editor, focusEditor);
        }
        return null;
    }

    protected Editor getOpenedEditor(Editor editor, boolean focusEditor) {
        return editor;
    }

    public Editor getSelectedTextEditor() {
        EditorWithProviderComposite selectedEditor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isFileOpen"));
        }
        return !this.getEditorComposites(file).isEmpty();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        HashSet<VirtualFile> openFiles = new HashSet<VirtualFile>();
        for (EditorsSplitters each : this.getAllSplitters()) {
            openFiles.addAll(Arrays.asList(each.getOpenFiles()));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(openFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getOpenFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        HashSet<VirtualFile> selectedFiles = new HashSet<VirtualFile>();
        for (EditorsSplitters each : this.getAllSplitters()) {
            selectedFiles.addAll(Arrays.asList(each.getSelectedFiles()));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(selectedFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        HashSet<FileEditor> selectedEditors = new HashSet<FileEditor>();
        for (EditorsSplitters each : this.getAllSplitters()) {
            selectedEditors.addAll(Arrays.asList(each.getSelectedEditors()));
        }
        FileEditor[] fileEditorArray = selectedEditors.toArray(new FileEditor[selectedEditors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedEditors"));
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        EditorsSplitters active = (EditorsSplitters)((Object)this.getActiveSplitters(true).getResult());
        EditorsSplitters editorsSplitters = active == null ? this.getMainSplitters() : active;
        if (editorsSplitters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSplitters"));
        }
        return editorsSplitters;
    }

    @Nullable
    public FileEditor getSelectedEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedEditor"));
        }
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider = this.getSelectedEditorWithProvider(file);
        return selectedEditorWithProvider == null ? null : (FileEditor)selectedEditorWithProvider.getFirst();
    }

    @Override
    @Nullable
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file) {
        EditorWithProviderComposite composite;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedEditorWithProvider"));
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file)) != null) {
            return composite.getSelectedEditorWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
        return composites.isEmpty() ? null : composites.get(0).getSelectedEditorWithProvider();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
        }
        FileEditorManagerImpl.assertReadAccess();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file);
        if (composite != null) {
            Pair pair = Pair.create((Object)composite.getEditors(), (Object)composite.getProviders());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
            }
            return pair;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
        if (!composites.isEmpty()) {
            Pair pair = Pair.create((Object)composites.get(0).getEditors(), (Object)composites.get(0).getProviders());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
        }
        return pair;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file) {
        EditorWithProviderComposite composite;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
        }
        FileEditorManagerImpl.assertReadAccess();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file)) != null) {
            FileEditor[] fileEditorArray = composite.getEditors();
            if (fileEditorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
            }
            return fileEditorArray;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
        if (!composites.isEmpty()) {
            FileEditor[] fileEditorArray = composites.get(0).getEditors();
            if (fileEditorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
            }
            return fileEditorArray;
        }
        if (EMPTY_EDITOR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
        }
        return EMPTY_EDITOR_ARRAY;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
        }
        List<EditorWithProviderComposite> editorComposites = this.getEditorComposites(file);
        if (editorComposites.isEmpty()) {
            if (EMPTY_EDITOR_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
            }
            return EMPTY_EDITOR_ARRAY;
        }
        ArrayList editors = new ArrayList();
        for (EditorWithProviderComposite composite : editorComposites) {
            ContainerUtil.addAll(editors, (Object[])composite.getEditors());
        }
        FileEditor[] fileEditorArray = editors.toArray(new FileEditor[editors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
        }
        return fileEditorArray;
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getCurrentEditorWithProviderComposite"));
        }
        EditorWindow editorWindow = this.getSplitters().getCurrentWindow();
        if (editorWindow != null) {
            return editorWindow.findFileComposite(virtualFile);
        }
        return null;
    }

    @NotNull
    public List<EditorWithProviderComposite> getEditorComposites(VirtualFile file) {
        ArrayList<EditorWithProviderComposite> result = new ArrayList<EditorWithProviderComposite>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            result.addAll(each.findEditorComposites(file));
        }
        ArrayList<EditorWithProviderComposite> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorComposites"));
        }
        return arrayList;
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditorManagerImpl.assertReadAccess();
        ArrayList result = new ArrayList();
        Set<EditorsSplitters> allSplitters = this.getAllSplitters();
        for (EditorsSplitters splitter : allSplitters) {
            EditorWithProviderComposite[] editorsComposites;
            for (EditorWithProviderComposite editorsComposite : editorsComposites = splitter.getEditorsComposites()) {
                Object[] editors = editorsComposite.getEditors();
                ContainerUtil.addAll(result, (Object[])editors);
            }
        }
        FileEditor[] fileEditorArray = result.toArray(new FileEditor[result.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
        }
        return fileEditorArray;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "showEditorAnnotation"));
        }
        if (annotationComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "showEditorAnnotation"));
        }
        this.addTopComponent(editor, annotationComponent);
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeEditorAnnotation"));
        }
        if (annotationComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeEditorAnnotation"));
        }
        this.removeTopComponent(editor, annotationComponent);
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addTopComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addTopComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addTopComponent(editor, component);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeTopComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeTopComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeTopComponent(editor, component);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addBottomComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addBottomComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addBottomComponent(editor, component);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeBottomComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeBottomComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeBottomComponent(editor, component);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addFileEditorManagerListener"));
        }
        this.myListenerList.add((Object)listener);
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addFileEditorManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addFileEditorManagerListener"));
        }
        this.myListenerList.add((Object)listener, parentDisposable);
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeFileEditorManagerListener"));
        }
        this.myListenerList.remove((Object)listener);
    }

    public void projectOpened() {
        this.getMainSplitters().startListeningFocus();
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            MyFileStatusListener myFileStatusListener = new MyFileStatusListener();
            fileStatusManager.addFileStatusListener((FileStatusListener)myFileStatusListener, (Disposable)this.myProject);
        }
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootsListener());
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this.myProject);
        MyUISettingsListener myUISettingsListener = new MyUISettingsListener();
        UISettings.getInstance().addUISettingsListener((UISettingsListener)myUISettingsListener, (Disposable)this.myProject);
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (FileEditorManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                FileEditorManagerImpl.this.setTabsMode(UISettings.getInstance().EDITOR_TAB_PLACEMENT != 0);
                ToolWindowManager.getInstance((Project)FileEditorManagerImpl.this.myProject).invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(FileEditorManagerImpl.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                LaterInvocator.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        long currentTime = System.nanoTime();
                                        Long startTime = (Long)FileEditorManagerImpl.this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                                        if (startTime != null) {
                                            LOG.info("Project opening took " + (currentTime - startTime) / 1000000L + " ms");
                                            PluginManagerCore.dumpPluginClassStatistics();
                                        }
                                    }
                                }, FileEditorManagerImpl.this.myProject.getDisposed());
                            }
                        }, "", null);
                    }
                });
            }
        });
    }

    public void projectClosed() {
        this.getMainSplitters().dispose();
        this.closeAllFiles();
    }

    @NotNull
    public String getComponentName() {
        if (FILE_EDITOR_MANAGER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getComponentName"));
        }
        return FILE_EDITOR_MANAGER;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void writeExternal(Element element) {
        this.getMainSplitters().writeExternal(element);
    }

    public void readExternal(Element element) {
        this.getMainSplitters().readExternal(element);
    }

    @Nullable
    private EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorComposite"));
        }
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            EditorWithProviderComposite[] editorsComposites = splitters.getEditorsComposites();
            for (int i = editorsComposites.length - 1; i >= 0; --i) {
                EditorWithProviderComposite composite = editorsComposites[i];
                FileEditor[] editors = composite.getEditors();
                for (int j = editors.length - 1; j >= 0; --j) {
                    FileEditor _editor = editors[j];
                    LOG.assertTrue(_editor != null);
                    if (!editor.equals(_editor)) continue;
                    return composite;
                }
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(EditorComposite newSelectedComposite) {
        boolean editorsEqual;
        boolean filesEqual;
        Trinity<VirtualFile, FileEditor, FileEditorProvider> oldData = FileEditorManagerImpl.extract((EditorComposite)this.myLastSelectedComposite.get());
        Trinity<VirtualFile, FileEditor, FileEditorProvider> newData = FileEditorManagerImpl.extract(newSelectedComposite);
        this.myLastSelectedComposite = new WeakReference<EditorComposite>(newSelectedComposite);
        boolean bl = oldData.first == null ? newData.first == null : (filesEqual = ((VirtualFile)oldData.first).equals(newData.first));
        boolean bl2 = oldData.second == null ? newData.second == null : (editorsEqual = ((FileEditor)oldData.second).equals(newData.second));
        if (!filesEqual || !editorsEqual) {
            JComponent component;
            EditorWindowHolder holder;
            if (oldData.first != null && newData.first != null) {
                for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, (VirtualFile)oldData.first);
                    if (!Comparing.equal((Object)associatedFile, (Object)newData.first)) continue;
                    return;
                }
            }
            final FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, (VirtualFile)oldData.first, (FileEditor)oldData.second, (FileEditorProvider)oldData.third, (VirtualFile)newData.first, (FileEditor)newData.second, (FileEditorProvider)newData.third);
            final FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            if (newData.first != null && (holder = (EditorWindowHolder)UIUtil.getParentOfType(EditorWindowHolder.class, (Component)(component = ((FileEditor)newData.second).getComponent()))) != null) {
                this.addSelectionRecord((VirtualFile)newData.first, holder.getEditorWindow());
            }
            this.notifyPublisher(new Runnable(){

                @Override
                public void run() {
                    publisher.selectionChanged(event);
                }
            });
        }
    }

    @NotNull
    private static Trinity<VirtualFile, FileEditor, FileEditorProvider> extract(@Nullable EditorComposite composite) {
        FileEditorProvider provider;
        FileEditor editor;
        VirtualFile file;
        if (composite == null || composite.isDisposed()) {
            file = null;
            editor = null;
            provider = null;
        } else {
            file = composite.getFile();
            Pair<FileEditor, FileEditorProvider> pair = composite.getSelectedEditorWithProvider();
            editor = (FileEditor)pair.first;
            provider = (FileEditorProvider)pair.second;
        }
        Trinity trinity = new Trinity((Object)file, (Object)editor, provider);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "extract"));
        }
        return trinity;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isChanged"));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            VirtualFile file = editor.getFile();
            FileStatus status = fileStatusManager.getStatus(file);
            if (status == FileStatus.UNKNOWN && !file.isWritable()) {
                return false;
            }
            if (!status.equals(FileStatus.NOT_CHANGED)) {
                return true;
            }
        }
        return false;
    }

    public void disposeComposite(@NotNull EditorWithProviderComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "disposeComposite"));
        }
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors = editor.getEditors();
        FileEditorProvider[] providers = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i = editors.length - 1; i >= 0; --i) {
            FileEditor editor1 = editors[i];
            FileEditorProvider provider = providers[i];
            if (!editor.equals(selectedEditor) && selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener((PropertyChangeListener)this.myEditorPropertyChangeListener);
            provider.disposeEditor(editor1);
        }
        Disposer.dispose((Disposable)editor);
    }

    @Nullable
    EditorComposite getLastSelected() {
        EditorWindow currentWindow = ((EditorsSplitters)((Object)this.getActiveSplitters(true).getResult())).getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChange(FileEditorManagerChange change, EditorsSplitters splitters) {
        HashSet<EditorsSplitters> target = new HashSet<EditorsSplitters>();
        if (splitters == null) {
            target.addAll(this.getAllSplitters());
        } else {
            target.add(splitters);
        }
        for (EditorsSplitters each : target) {
            ++each.myInsideChange;
            try {
                change.run(each);
            }
            finally {
                --each.myInsideChange;
            }
        }
    }

    private static boolean moveFocusOnDelete() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            Component component = FocusTrackback.getFocusFor(window);
            if (component != null) {
                return component instanceof EditorComponentImpl;
            }
            return window instanceof IdeFrameImpl;
        }
        return true;
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        VirtualFile[] openFiles;
        for (VirtualFile openFile : openFiles = this.getSplitters().getOpenFiles()) {
            this.closeFile(openFile);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSiblings"));
        }
        VirtualFile[] virtualFileArray = this.getOpenFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSiblings"));
        }
        return virtualFileArray;
    }

    protected void queueUpdateFile(final VirtualFile file) {
        this.myQueue.queue(new Update(file){

            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file)) {
                    FileEditorManagerImpl.this.updateFileIcon(file);
                    FileEditorManagerImpl.this.updateFileColor(file);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file);
                }
            }
        });
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        EditorsSplitters splitters = null;
        DockContainer dockContainer = this.myDockManager.getContainerFor(c);
        if (dockContainer instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)dockContainer).getSplitters();
        }
        if (splitters == null) {
            splitters = this.getMainSplitters();
        }
        return splitters;
    }

    public List<Pair<VirtualFile, EditorWindow>> getSelectionHistory() {
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Pair<VirtualFile, EditorWindow> pair : this.mySelectionHistory) {
            if (((EditorWindow)pair.second).getFiles().length == 0) {
                Pair p;
                EditorWindow[] windows = ((EditorWindow)pair.second).getOwner().getWindows();
                if (windows.length <= 0 || windows[0] == null || windows[0].getFiles().length <= 0 || copy.contains(p = Pair.create((Object)pair.first, (Object)windows[0]))) continue;
                copy.add(p);
                continue;
            }
            if (copy.contains(pair)) continue;
            copy.add(pair);
        }
        this.mySelectionHistory.clear();
        this.mySelectionHistory.addAll(copy);
        return this.mySelectionHistory;
    }

    public void addSelectionRecord(VirtualFile file, EditorWindow window) {
        Pair record = Pair.create((Object)file, (Object)window);
        this.mySelectionHistory.remove(record);
        this.mySelectionHistory.add(0, (Pair<VirtualFile, EditorWindow>)record);
    }

    public void removeSelectionRecord(VirtualFile file, EditorWindow window) {
        this.mySelectionHistory.remove(Pair.create((Object)file, (Object)window));
    }

    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getReady"));
        }
        return this.myBusyObject.getReady(requestor);
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings source) {
            FileEditorManagerImpl.assertDispatchThread();
            FileEditorManagerImpl.this.setTabsMode(source.EDITOR_TAB_PLACEMENT != 0 && !UISettings.getInstance().PRESENTATION_MODE);
            for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                each.setTabsPlacement(source.EDITOR_TAB_PLACEMENT);
                each.trimToSize(source.EDITOR_TAB_LIMIT);
                if (source.SCROLL_TAB_LAYOUT_IN_EDITOR) {
                    each.setTabLayoutPolicy(1);
                    continue;
                }
                each.setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file = openFiles[i];
                FileEditorManagerImpl.this.updateFileIcon(file);
                FileEditorManagerImpl.this.updateFileName(file);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file);
            }
        }
    }

    private class MyRootsListener
    extends ModuleRootAdapter {
        private MyRootsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rootsChanged(ModuleRootEvent event) {
            EditorFileSwapper[] swappers = (EditorFileSwapper[])Extensions.getExtensions(EditorFileSwapper.EP_NAME);
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                EditorWithProviderComposite selected = eachWindow.getSelectedEditor();
                EditorWithProviderComposite[] editors = eachWindow.getEditors();
                for (int i = 0; i < editors.length; ++i) {
                    VirtualFile newFile;
                    EditorFileSwapper each;
                    EditorWithProviderComposite editor = editors[i];
                    VirtualFile file = editor.getFile();
                    if (!file.isValid()) continue;
                    Pair<VirtualFile, Integer> newFilePair = null;
                    EditorFileSwapper[] arr$ = swappers;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (newFilePair = (each = arr$[i$]).getFileToSwapTo(FileEditorManagerImpl.this.myProject, editor)) == null; ++i$) {
                    }
                    if (newFilePair == null || (newFile = (VirtualFile)newFilePair.first) == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    try {
                        TextEditorImpl openedEditor;
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)i);
                        Pair<FileEditor[], FileEditorProvider[]> pair = FileEditorManagerImpl.this.openFileImpl2(eachWindow, newFile, editor == selected);
                        if (newFilePair.second != null && (openedEditor = EditorFileSwapper.findSinglePsiAwareEditor((FileEditor[])pair.first)) != null) {
                            openedEditor.getEditor().getCaretModel().moveToOffset(((Integer)newFilePair.second).intValue());
                            openedEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                    FileEditorManagerImpl.this.closeFile(file, eachWindow);
                }
            }
        }
    }

    private final class MyFileTypeListener
    extends FileTypeListener.Adapter {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(FileTypeEvent event) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file = openFiles[i];
                LOG.assertTrue(file != null);
                FileEditorManagerImpl.this.updateFileIcon(file);
            }
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                final VirtualFile file = openFiles[i];
                LOG.assertTrue(file != null);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("updating file status in tab for " + file.getPath());
                        }
                        MyFileStatusListener.this.updateFileStatus(file);
                    }
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        public void fileStatusChanged(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileStatusListener", "fileStatusChanged"));
            }
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file)) {
                this.updateFileStatus(file);
            }
        }

        private void updateFileStatus(VirtualFile file) {
            FileEditorManagerImpl.this.updateFileColor(file);
            FileEditorManagerImpl.this.updateFileIcon(file);
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean valid;
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }
    }

    private final class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(VirtualFileEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            boolean moveFocus = FileEditorManagerImpl.moveFocusOnDelete();
            VirtualFile file = e.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)openFiles[i], (boolean)false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i], moveFocus, true);
            }
        }

        public void propertyChanged(VirtualFilePropertyEvent e) {
            if ("name".equals(e.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file = e.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file)) {
                    FileEditorManagerImpl.this.updateFileName(file);
                    FileEditorManagerImpl.this.updateFileIcon(file);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file);
                }
            } else if ("writable".equals(e.getPropertyName()) || "encoding".equals(e.getPropertyName())) {
                this.updateIconAndStatusBar(e);
            }
        }

        private void updateIconAndStatusBar(VirtualFilePropertyEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file = e.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file)) {
                FileEditorManagerImpl.this.updateFileIcon(file);
                if (file.equals(FileEditorManagerImpl.this.getSelectedFiles()[0])) {
                    StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(FileEditorManagerImpl.this.myProject);
                    assert (statusBar != null);
                    statusBar.updateWidgets();
                }
            }
        }

        public void fileMoved(VirtualFileMoveEvent e) {
            VirtualFile[] openFiles;
            VirtualFile file = e.getFile();
            for (VirtualFile openFile : openFiles = FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)openFile, (boolean)false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile);
            }
        }
    }

    private static class MyBorder
    implements Border {
        private MyBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UIUtil.isUnderAquaLookAndFeel()) {
                g.setColor(JBTabsImpl.MAC_AQUA_BG_COLOR);
                Insets insets = this.getBorderInsets(c);
                if (insets.top > 0) {
                    g.fillRect(x, y, width, height + insets.top);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBInsets.NONE;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

