/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.RootFileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.chooser.FileTreeStructure");
    private final RootFileElement myRootElement;
    private final FileChooserDescriptor myChooserDescriptor;
    private boolean myShowHidden;
    private final Project myProject;

    public FileTreeStructure(Project project, FileChooserDescriptor chooserDescriptor) {
        this.myProject = project;
        VirtualFile[] rootFiles = VfsUtilCore.toVirtualFileArray((Collection)chooserDescriptor.getRoots());
        String name = rootFiles.length == 1 && rootFiles[0] != null ? rootFiles[0].getPresentableUrl() : chooserDescriptor.getTitle();
        this.myRootElement = new RootFileElement(rootFiles, name, chooserDescriptor.isShowFileSystemRoots());
        this.myChooserDescriptor = chooserDescriptor;
        this.myShowHidden = PropertiesComponent.getInstance().getBoolean("FileChooser.showHiddens", false);
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return true;
    }

    public final boolean areHiddensShown() {
        return this.myShowHidden;
    }

    public final void showHiddens(boolean showHidden) {
        this.myShowHidden = showHidden;
    }

    public final Object getRootElement() {
        return this.myRootElement;
    }

    public Object[] getChildElements(Object nodeElement) {
        if (!(nodeElement instanceof FileElement)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        FileElement element = (FileElement)nodeElement;
        VirtualFile file = element.getFile();
        if (file == null || !file.isValid()) {
            if (element == this.myRootElement) {
                return this.myRootElement.getChildren();
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        VirtualFile[] children = null;
        if (element.isArchive() && this.myChooserDescriptor.isChooseJarContents()) {
            String path = file.getPath();
            if (!(file.getFileSystem() instanceof JarFileSystem)) {
                file = JarFileSystem.getInstance().findFileByPath(path + "!/");
            }
            if (file != null) {
                children = file.getChildren();
            }
        } else {
            children = file.getChildren();
        }
        if (children == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        HashSet<FileElement> childrenSet = new HashSet<FileElement>();
        for (VirtualFile child : children) {
            if (!this.myChooserDescriptor.isFileVisible(child, this.myShowHidden)) continue;
            FileElement childElement = new FileElement(child, child.getName());
            childElement.setParent(element);
            childrenSet.add(childElement);
        }
        return ArrayUtil.toObjectArray(childrenSet);
    }

    @Nullable
    public Object getParentElement(Object element) {
        if (element instanceof FileElement) {
            VirtualFile parentFile;
            FileElement fileElement = (FileElement)element;
            VirtualFile elementFile = FileTreeStructure.getValidFile(fileElement);
            if (elementFile != null && this.myRootElement.getFile() != null && this.myRootElement.getFile().equals(elementFile)) {
                return null;
            }
            VirtualFile parentElementFile = FileTreeStructure.getValidFile(fileElement.getParent());
            if (elementFile != null && parentElementFile != null && parentElementFile.equals(parentFile = elementFile.getParent())) {
                return fileElement.getParent();
            }
            VirtualFile file = fileElement.getFile();
            if (file == null) {
                return null;
            }
            VirtualFile parent = file.getParent();
            if (parent != null && parent.getFileSystem() instanceof JarFileSystem && parent.getParent() == null) {
                String localPath = parent.getPath().substring(0, parent.getPath().length() - "!/".length());
                parent = LocalFileSystem.getInstance().findFileByPath(localPath);
            }
            if (parent != null && parent.isValid() && parent.equals(this.myRootElement.getFile())) {
                return this.myRootElement;
            }
            if (parent == null) {
                return this.myRootElement;
            }
            return new FileElement(parent, parent.getName());
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidFile(FileElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile file = element.getFile();
        return file != null && file.isValid() ? file : null;
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    public final void dispose() {
        PropertiesComponent.getInstance().setValue("FileChooser.showHiddens", Boolean.toString(this.myShowHidden));
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        LOG.assertTrue(element instanceof FileElement, (Object)element.getClass().getName());
        VirtualFile file = ((FileElement)element).getFile();
        Icon closedIcon = file == null ? null : this.myChooserDescriptor.getIcon(file);
        String name = file == null ? null : this.myChooserDescriptor.getName(file);
        String comment = file == null ? null : this.myChooserDescriptor.getComment(file);
        FileNodeDescriptor fileNodeDescriptor = new FileNodeDescriptor(this.myProject, (FileElement)element, parentDescriptor, closedIcon, name, comment);
        if (fileNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileTreeStructure", "createDescriptor"));
        }
        return fileNodeDescriptor;
    }
}

