/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.file.exclude.PersistentFileSetManager;
import com.intellij.openapi.file.exclude.ProjectFileExclusionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFileExclusionManager", storages={@Storage(file="$PROJECT_FILE$")})
public class ProjectFileExclusionManagerImpl
extends PersistentFileSetManager
implements ProjectFileExclusionManager {
    private final Project myProject;

    public ProjectFileExclusionManagerImpl(Project project) {
        this.myProject = project;
    }

    public void addExclusion(VirtualFile file) {
        if (this.addFile(file)) {
            FileBasedIndex.getInstance().requestReindexExcluded(file);
            ProjectFileExclusionManagerImpl.fireRootsChange(this.myProject);
        }
    }

    public void removeExclusion(VirtualFile file) {
        if (this.removeFile(file)) {
            FileBasedIndex.getInstance().requestReindex(file);
            ProjectFileExclusionManagerImpl.fireRootsChange(this.myProject);
        }
    }

    private static void fireRootsChange(final Project project) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerEx.getInstanceEx(project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
            }
        });
    }

    public boolean isExcluded(VirtualFile file) {
        return this.containsFile(file);
    }

    public Collection<VirtualFile> getExcludedFiles() {
        return this.getFiles();
    }

    public static ProjectFileExclusionManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/file/exclude/ProjectFileExclusionManagerImpl", "getInstance"));
        }
        return (ProjectFileExclusionManagerImpl)ServiceManager.getService((Project)project, ProjectFileExclusionManager.class);
    }
}

