/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemRecentTaskListModel
extends DefaultListModel {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;

    public ExternalSystemRecentTaskListModel(@NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTaskListModel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTaskListModel", "<init>"));
        }
        this.myExternalSystemId = externalSystemId;
        this.myProject = project;
        this.ensureSize(ExternalSystemConstants.RECENT_TASKS_NUMBER);
    }

    public void setTasks(@NotNull List<ExternalTaskExecutionInfo> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTaskListModel", "setTasks"));
        }
        this.clear();
        ArrayList tasksToUse = ContainerUtilRt.newArrayList(tasks);
        for (ExternalTaskExecutionInfo task : tasksToUse) {
            this.addElement(task);
        }
    }

    public void setFirst(@NotNull ExternalTaskExecutionInfo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTaskListModel", "setFirst"));
        }
        this.insertElementAt(task, 0);
        for (int i = 1; i < this.size(); ++i) {
            if (!task.equals(this.getElementAt(i))) continue;
            this.remove(i);
            break;
        }
        this.ensureSize(ExternalSystemConstants.RECENT_TASKS_NUMBER);
    }

    @NotNull
    public List<ExternalTaskExecutionInfo> getTasks() {
        ArrayList result = ContainerUtilRt.newArrayList();
        for (int i = 0; i < this.size(); ++i) {
            Object e = this.getElementAt(i);
            if (!(e instanceof ExternalTaskExecutionInfo)) continue;
            result.add((ExternalTaskExecutionInfo)e);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTaskListModel", "getTasks"));
        }
        return arrayList;
    }

    public void ensureSize(int elementsNumber) {
        int toAdd = elementsNumber - this.size();
        if (toAdd == 0) {
            return;
        }
        if (toAdd < 0) {
            this.removeRange(elementsNumber, this.size() - 1);
        }
        while (--toAdd >= 0) {
            this.addElement(new MyEmptyDescriptor());
        }
    }

    public void forgetTasksFrom(@NotNull String externalProjectPath) {
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTaskListModel", "forgetTasksFrom"));
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            String path;
            Object e = this.getElementAt(i);
            if (!(e instanceof ExternalTaskExecutionInfo) || !externalProjectPath.equals(path = ((ExternalTaskExecutionInfo)e).getSettings().getExternalProjectPath()) && !externalProjectPath.equals(ExternalSystemApiUtil.getRootProjectPath((String)path, (ProjectSystemId)this.myExternalSystemId, (Project)this.myProject))) continue;
            this.removeElementAt(i);
        }
        this.ensureSize(ExternalSystemConstants.RECENT_TASKS_NUMBER);
    }

    static class MyEmptyDescriptor {
        MyEmptyDescriptor() {
        }
    }
}

