/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolWindowService<T extends ExternalEntityData>
implements ProjectDataService<T, Void> {
    public void importData(final @NotNull Collection<DataNode<T>> toImport, final @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/AbstractToolWindowService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/task/AbstractToolWindowService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        ExternalSystemApiUtil.executeOnEdt((boolean)false, (Runnable)new Runnable(){

            @Override
            public void run() {
                ExternalSystemTasksTreeModel model = ExternalSystemUtil.getToolWindowElement(ExternalSystemTasksTreeModel.class, project, ExternalSystemDataKeys.ALL_TASKS_MODEL, ((ExternalEntityData)((DataNode)toImport.iterator().next()).getData()).getOwner());
                AbstractToolWindowService.this.processData(toImport, project, model);
            }
        });
    }

    protected abstract void processData(@NotNull Collection<DataNode<T>> var1, @NotNull Project var2, @Nullable ExternalSystemTasksTreeModel var3);

    public void removeData(@NotNull Collection<? extends Void> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/AbstractToolWindowService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/task/AbstractToolWindowService", "removeData"));
        }
    }
}

