/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote.wrapper;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.AbstractRemoteExternalSystemServiceWrapper;
import java.rmi.RemoteException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskManagerWrapper<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemServiceWrapper<S, RemoteExternalSystemTaskManager<S>>
implements RemoteExternalSystemTaskManager<S> {
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;

    public ExternalSystemTaskManagerWrapper(@NotNull RemoteExternalSystemTaskManager<S> delegate, @NotNull RemoteExternalSystemProgressNotificationManager progressManager) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "<init>"));
        }
        if (progressManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "<init>"));
        }
        super(delegate);
        this.myProgressManager = progressManager;
    }

    @Override
    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable S settings, @NotNull List<String> vmOptions, @NotNull List<String> scriptParameters, @Nullable String debuggerSetup) throws RemoteException, ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "executeTasks"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "executeTasks"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "executeTasks"));
        }
        if (vmOptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "executeTasks"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "executeTasks"));
        }
        this.myProgressManager.onQueued(id);
        try {
            ((RemoteExternalSystemTaskManager)this.getDelegate()).executeTasks(id, taskNames, projectPath, settings, vmOptions, scriptParameters, debuggerSetup);
        }
        catch (ExternalSystemException e) {
            this.myProgressManager.onFailure(id, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.myProgressManager.onFailure(id, e);
            throw new ExternalSystemException((Throwable)e);
        }
        finally {
            this.myProgressManager.onEnd(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws RemoteException, ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemTaskManagerWrapper", "cancelTask"));
        }
        this.myProgressManager.onQueued(id);
        try {
            boolean bl = ((RemoteExternalSystemTaskManager)this.getDelegate()).cancelTask(id);
            return bl;
        }
        finally {
            this.myProgressManager.onEnd(id);
        }
    }
}

