/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.AbstractRemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.AbstractExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.util.Producer;
import com.intellij.util.execution.ParametersListUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteExternalSystemTaskManagerImpl<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemService<S>
implements RemoteExternalSystemTaskManager<S> {
    @NotNull
    private final ExternalSystemTaskManager<S> myDelegate;

    public RemoteExternalSystemTaskManagerImpl(@NotNull ExternalSystemTaskManager<S> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    public void executeTasks(final @NotNull ExternalSystemTaskId id, final @NotNull List<String> taskNames, final @NotNull String projectPath, final @Nullable S settings, final @NotNull List<String> vmOptions, final @NotNull List<String> scriptParameters, final @Nullable String debuggerSetup) throws RemoteException, ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "executeTasks"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "executeTasks"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "executeTasks"));
        }
        if (vmOptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "executeTasks"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "executeTasks"));
        }
        this.execute(id, new Producer<Object>(){

            @Nullable
            public Object produce() {
                if (RemoteExternalSystemTaskManagerImpl.this.myDelegate instanceof AbstractExternalSystemTaskManager) {
                    ((AbstractExternalSystemTaskManager)RemoteExternalSystemTaskManagerImpl.this.myDelegate).executeTasks(id, taskNames, projectPath, settings, vmOptions, scriptParameters, debuggerSetup, RemoteExternalSystemTaskManagerImpl.this.getNotificationListener());
                } else {
                    RemoteExternalSystemTaskManagerImpl.this.myDelegate.executeTasks(id, taskNames, projectPath, settings, ParametersListUtil.join((List)vmOptions), debuggerSetup, RemoteExternalSystemTaskManagerImpl.this.getNotificationListener());
                }
                return null;
            }
        });
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws RemoteException, ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManagerImpl", "cancelTask"));
        }
        return this.myDelegate.cancelTask(id, this.getNotificationListener());
    }
}

