/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalModuleBuilder<S extends ExternalProjectSettings>
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractExternalModuleBuilder.class.getName()));
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final S myExternalProjectSettings;

    protected AbstractExternalModuleBuilder(@NotNull ProjectSystemId externalSystemId, @NotNull S externalProjectSettings) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder", "<init>"));
        }
        if (externalProjectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder", "<init>"));
        }
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectSettings = externalProjectSettings;
        Icon icon = ExternalSystemUiUtil.getUiAware(externalSystemId).getProjectIcon();
        this.myIcon = icon == null ? super.getNodeIcon() : icon;
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getDescription() {
        return ExternalSystemBundle.message((String)"module.type.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getNodeIcon() {
        return this.myIcon;
    }

    @NotNull
    public S getExternalProjectSettings() {
        S s = this.myExternalProjectSettings;
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder", "getExternalProjectSettings"));
        }
        return s;
    }
}

