/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectStructureHelper;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=42)
public class ContentRootDataService
implements ProjectDataService<ContentRootData, ContentEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ContentRootDataService.class.getName()));
    @NotNull
    private final ProjectStructureHelper myProjectStructureHelper;

    public ContentRootDataService(@NotNull ProjectStructureHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "<init>"));
        }
        this.myProjectStructureHelper = helper;
    }

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        Map byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = this.myProjectStructureHelper.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
            if (module == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData((Collection)entry.getValue(), module, synchronous);
        }
    }

    private static void importData(final @NotNull Collection<DataNode<ContentRootData>> data, final @NotNull Module module, boolean synchronous) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)module){

            public void execute() {
                ModuleRootModificationUtil.updateModel(module, new Consumer<ModifiableRootModel>(){

                    public void consume(ModifiableRootModel model) {
                        ContentEntry[] contentEntries = model.getContentEntries();
                        HashMap contentEntriesMap = ContainerUtilRt.newHashMap();
                        for (ContentEntry contentEntry : contentEntries) {
                            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
                        }
                        boolean createEmptyContentRootDirectories = false;
                        if (!data.isEmpty()) {
                            ProjectSystemId projectSystemId = ((ContentRootData)((DataNode)data.iterator().next()).getData()).getOwner();
                            AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module.getProject(), (ProjectSystemId)projectSystemId);
                            String path = module.getOptionValue("external.root.project.path");
                            if (path != null) {
                                ExternalProjectSettings projectSettings = externalSystemSettings.getLinkedProjectSettings(path);
                                createEmptyContentRootDirectories = projectSettings != null && projectSettings.isCreateEmptyContentRootDirectories();
                            }
                        }
                        for (DataNode node : data) {
                            ContentRootData contentRoot = (ContentRootData)node.getData();
                            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(model, contentRoot.getRootPath());
                            contentEntry.clearExcludeFolders();
                            contentEntry.clearSourceFolders();
                            LOG.info(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module.getName()));
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.SOURCE)) {
                                ContentRootDataService.createSourceRootIfAbsent(contentEntry, root, module.getName(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, false, createEmptyContentRootDirectories);
                            }
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.TEST)) {
                                ContentRootDataService.createSourceRootIfAbsent(contentEntry, root, module.getName(), (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, false, createEmptyContentRootDirectories);
                            }
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.RESOURCE)) {
                                ContentRootDataService.createSourceRootIfAbsent(contentEntry, root, module.getName(), (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE, false, createEmptyContentRootDirectories);
                            }
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.TEST_RESOURCE)) {
                                ContentRootDataService.createSourceRootIfAbsent(contentEntry, root, module.getName(), (JpsModuleSourceRootType)JavaResourceRootType.TEST_RESOURCE, false, createEmptyContentRootDirectories);
                            }
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.SOURCE_GENERATED)) {
                                ContentRootDataService.createSourceRootIfAbsent(contentEntry, root, module.getName(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, true, createEmptyContentRootDirectories);
                            }
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.TEST_GENERATED)) {
                                ContentRootDataService.createSourceRootIfAbsent(contentEntry, root, module.getName(), (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, true, createEmptyContentRootDirectories);
                            }
                            for (ContentRootData.SourceRoot root : contentRoot.getRoots(ExternalSystemSourceType.EXCLUDED)) {
                                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, root, module.getName());
                            }
                            contentEntriesMap.remove(contentEntry.getUrl());
                        }
                        for (ContentEntry contentEntry : contentEntriesMap.values()) {
                            model.removeContentEntry(contentEntry);
                        }
                    }
                });
            }
        });
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
        }
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(path)) continue;
            ContentEntry contentEntry = entry;
            if (contentEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model.addContentEntry(ContentRootDataService.toVfsUrl(path));
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
        }
        return contentEntry;
    }

    private static void createSourceRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull JpsModuleSourceRootType sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        if (sourceRootType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        List folders = entry.getSourceFolders(sourceRootType);
        for (SourceFolder folder : folders) {
            VirtualFile file = folder.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(root.getPath())) continue;
            return;
        }
        LOG.info(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        SourceFolder sourceFolder = entry.addSourceFolder(ContentRootDataService.toVfsUrl(root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories) {
            try {
                VfsUtil.createDirectoryIfMissing((String)root.getPath());
            }
            catch (IOException e) {
                LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
            }
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        for (VirtualFile file : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(root.getPath())) continue;
            return;
        }
        LOG.info(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        entry.addExcludeFolder(ContentRootDataService.toVfsUrl(root.getPath()));
    }

    public void removeData(@NotNull Collection<? extends ContentEntry> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "removeData"));
        }
    }

    private static String toVfsUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "toVfsUrl"));
        }
        return "file://" + path;
    }
}

