/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureHelper {
    @NotNull
    private final PlatformFacade myFacade;

    public ProjectStructureHelper(@NotNull PlatformFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "<init>"));
        }
        this.myFacade = facade;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module, @NotNull Project ideProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        return this.findIdeModule(module.getInternalName(), ideProject);
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName, @NotNull Project ideProject) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        for (Module module : this.myFacade.getModules(ideProject)) {
            if (!ideModuleName.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData, @NotNull Project ideProject) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeLibrary"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeLibrary"));
        }
        LibraryTable libraryTable = this.myFacade.getProjectLibraryTable(ideProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    public static boolean isOrphanProjectLibrary(final @NotNull Library library, @NotNull Iterable<Module> ideModules) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "isOrphanProjectLibrary"));
        }
        if (ideModules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "isOrphanProjectLibrary"));
        }
        RootPolicy<Boolean> visitor = new RootPolicy<Boolean>(){

            public Boolean visitLibraryOrderEntry(LibraryOrderEntry ideDependency, Boolean value) {
                return !ideDependency.isModuleLevel() && library == ideDependency.getLibrary();
            }
        };
        for (Module module : ideModules) {
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!((Boolean)entry.accept((RootPolicy)visitor, (Object)false)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull ModifiableRootModel model) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModuleDependency"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModuleDependency"));
        }
        for (OrderEntry entry : model.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry candidate = (ModuleOrderEntry)entry;
            if (!dependency.getInternalName().equals(candidate.getModuleName()) || !dependency.getScope().equals((Object)candidate.getScope())) continue;
            return candidate;
        }
        return null;
    }
}

