/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProjectRenameAware {
    public static void beAware(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectRenameAware", "beAware"));
        }
        final ExternalSystemFacadeManager facadeManager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
            settings.subscribe((ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

                public void onProjectRenamed(@NotNull String oldName, @NotNull String newName) {
                    if (oldName == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/ProjectRenameAware$1", "onProjectRenamed"));
                    }
                    if (newName == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/ProjectRenameAware$1", "onProjectRenamed"));
                    }
                    facadeManager.onProjectRename(oldName, newName);
                }
            });
        }
    }
}

