/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> myExternalProject;
    @NotNull
    private final String myProjectPath;
    private final boolean myIsPreviewMode;

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull String projectPath, boolean isPreviewMode) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        super(externalSystemId, ExternalSystemTaskType.RESOLVE_PROJECT, project, projectPath);
        this.myExternalProject = new AtomicReference();
        this.myProjectPath = projectPath;
        this.myIsPreviewMode = isPreviewMode;
    }

    @Override
    protected void doExecute() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver<ExternalSystemExecutionSettings> resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)ideProject, (String)this.myProjectPath, (ProjectSystemId)this.getExternalSystemId());
        DataNode<ProjectData> project = resolver.resolveProjectInfo(this.getId(), this.myProjectPath, this.myIsPreviewMode, settings);
        if (project == null) {
            return;
        }
        this.myExternalProject.set(project);
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        return resolver.cancelTask(this.getId());
    }

    @Nullable
    public DataNode<ProjectData> getExternalProject() {
        return this.myExternalProject.get();
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "wrapProgressText"));
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), text});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "wrapProgressText"));
        }
        return string;
    }
}

