/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskSettingsControl
implements ExternalSystemSettingsControl<ExternalSystemTaskExecutionSettings> {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;
    private JBLabel myProjectPathLabel;
    private ExternalProjectPathField myProjectPathField;
    private JBLabel myTasksLabel;
    private JBTextField myTasksTextField;
    private JBLabel myVmOptionsLabel;
    private RawCommandLineEditor myVmOptionsEditor;
    private JBLabel myScriptParametersLabel;
    private RawCommandLineEditor myScriptParametersEditor;
    @Nullable
    private ExternalSystemTaskExecutionSettings myOriginalSettings;

    public ExternalSystemTaskSettingsControl(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl", "<init>"));
        }
        this.myProject = project;
        this.myExternalSystemId = externalSystemId;
    }

    public void setOriginalSettings(@Nullable ExternalSystemTaskExecutionSettings originalSettings) {
        this.myOriginalSettings = originalSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl", "fillUi"));
        }
        this.myProjectPathLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.project", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}));
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
        FileChooserDescriptor projectPathChooserDescriptor = null;
        if (manager instanceof ExternalSystemUiAware) {
            projectPathChooserDescriptor = ((ExternalSystemUiAware)manager).getExternalProjectConfigDescriptor();
        }
        if (projectPathChooserDescriptor == null) {
            projectPathChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        }
        String title = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
        this.myProjectPathField = new ExternalProjectPathField(this.myProject, this.myExternalSystemId, projectPathChooserDescriptor, title){

            public Dimension getPreferredSize() {
                return ExternalSystemTaskSettingsControl.this.myVmOptionsEditor == null ? super.getPreferredSize() : ExternalSystemTaskSettingsControl.this.myVmOptionsEditor.getTextField().getPreferredSize();
            }
        };
        canvas.add((Component)this.myProjectPathLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)((Object)this.myProjectPathField), ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myTasksLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.tasks", (Object[])new Object[0]));
        this.myTasksTextField = new JBTextField(20);
        canvas.add((Component)this.myTasksLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        GridBag c = ExternalSystemUiUtil.getFillLineConstraints(0);
        c.insets.right = this.myProjectPathField.getButton().getPreferredSize().width + 8;
        canvas.add((Component)this.myTasksTextField, c);
        this.myVmOptionsLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        this.myVmOptionsEditor = new RawCommandLineEditor();
        this.myVmOptionsEditor.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        canvas.add((Component)this.myVmOptionsLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)this.myVmOptionsEditor, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myScriptParametersLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.script.parameters", (Object[])new Object[0]));
        this.myScriptParametersEditor = new RawCommandLineEditor();
        this.myScriptParametersEditor.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.script.parameters", (Object[])new Object[0]));
        canvas.add((Component)this.myScriptParametersLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)this.myScriptParametersEditor, ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @Override
    public void reset() {
        this.myProjectPathField.setText("");
        this.myTasksTextField.setText("");
        this.myVmOptionsEditor.setText("");
        this.myScriptParametersEditor.setText("");
        this.showUi(true);
        if (this.myOriginalSettings == null) {
            return;
        }
        String path = this.myOriginalSettings.getExternalProjectPath();
        if (StringUtil.isEmpty((String)path)) {
            path = "";
        }
        this.myProjectPathField.setText(path);
        this.myTasksTextField.setText(StringUtil.join((Collection)this.myOriginalSettings.getTaskNames(), (String)" "));
        this.myVmOptionsEditor.setText(this.myOriginalSettings.getVmOptions());
        this.myScriptParametersEditor.setText(this.myOriginalSettings.getScriptParameters());
    }

    @Override
    public boolean isModified() {
        if (this.myOriginalSettings == null) {
            return false;
        }
        return !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myProjectPathField.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getExternalProjectPath())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myTasksTextField.getText()), (String)ExternalSystemApiUtil.normalizePath((String)StringUtil.join((Collection)this.myOriginalSettings.getTaskNames(), (String)" "))) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myVmOptionsEditor.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getVmOptions())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myScriptParametersEditor.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getScriptParameters()));
    }

    @Override
    public void apply(@NotNull ExternalSystemTaskExecutionSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl", "apply"));
        }
        String projectPath = this.myProjectPathField.getText();
        settings.setExternalProjectPath(projectPath);
        settings.setTaskNames(StringUtil.split((String)this.myTasksTextField.getText(), (String)" "));
        settings.setVmOptions(this.myVmOptionsEditor.getText());
        settings.setScriptParameters(this.myScriptParametersEditor.getText());
    }

    @Override
    public boolean validate(@NotNull ExternalSystemTaskExecutionSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl", "validate"));
        }
        String projectPath = this.myProjectPathField.getText();
        if (this.myOriginalSettings == null) {
            throw new ConfigurationException(String.format("Can't store external task settings into run configuration. Reason: target run configuration is undefined. Tasks: '%s', external project: '%s', vm options: '%s', script parameters: '%s'", this.myTasksTextField.getText(), projectPath, this.myVmOptionsEditor.getText(), this.myScriptParametersEditor.getText()));
        }
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi(this, show);
    }
}

