/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ConfigurationFactory[] myFactories;
    @NotNull
    private final NotNullLazyValue<Icon> myIcon;

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "<init>"));
        }
        this.myFactories = new ConfigurationFactory[1];
        this.myIcon = new NotNullLazyValue<Icon>(){

            @NotNull
            protected Icon compute() {
                ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId);
                Icon result = null;
                if (manager instanceof ExternalSystemUiAware) {
                    result = ((ExternalSystemUiAware)manager).getProjectIcon();
                }
                Icon icon = result == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$1", "compute"));
                }
                return icon;
            }
        };
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            public RunConfiguration createTemplateConfiguration(Project project) {
                return AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project, this, "");
            }
        };
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        ConfigurationFactory configurationFactory = this.myFactories[0];
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "getFactory"));
        }
        return configurationFactory;
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        ExternalSystemRunConfiguration externalSystemRunConfiguration = new ExternalSystemRunConfiguration(externalSystemId, project, factory, name);
        if (externalSystemRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        return externalSystemRunConfiguration;
    }

    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message((String)"run.configuration.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @NotNull
    public String getId() {
        String string = this.myExternalSystemId.getReadableName() + "RunConfiguration";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "getId"));
        }
        return string;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    public static String generateName(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project, @NotNull ExternalTaskPojo task, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project, externalSystemId, task.getLinkedExternalProjectPath(), Collections.singletonList(task.getName()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemSettings s = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        HashMap rootProjectPaths = ContainerUtilRt.newHashMap();
        for (ExternalProjectSettings projectSettings : s.getLinkedProjectsSettings()) {
            File rootProjectPathFile;
            String path = projectSettings.getExternalProjectPath();
            if (path == null || (rootProjectPathFile = new File(path).getParentFile()) == null) continue;
            rootProjectPaths.put(rootProjectPathFile.getAbsolutePath(), path);
        }
        String rootProjectPath = null;
        if (externalProjectPath != null && !rootProjectPaths.containsKey(externalProjectPath)) {
            File prev = null;
            for (File f = new File(externalProjectPath); f != null && !FileUtil.filesEqual((File)f, prev) && (rootProjectPath = (String)rootProjectPaths.get(f.getAbsolutePath())) == null; f = f.getParentFile()) {
                prev = f;
            }
        }
        StringBuilder buffer = new StringBuilder();
        String projectName = rootProjectPath == null ? null : ExternalSystemApiUtil.getProjectRepresentationName((String)externalProjectPath, rootProjectPath);
        if (!StringUtil.isEmptyOrSpaces((String)projectName)) {
            buffer.append(projectName);
            buffer.append(" ");
        }
        buffer.append("[");
        if (!taskNames.isEmpty()) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(" ");
            }
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append("]");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }
}

